

module.exports.timediff = (start_time, end_time) => {
  var date1 = new Date(start_time);
  var date2 = new Date(end_time);
  var diff = date2.getTime() - date1.getTime();
  var msec = diff;
  var hh = Math.floor(msec / 1000 / 60 / 60);
  msec -= hh * 1000 * 60 * 60;

  var mm = Math.floor(msec / 1000 / 60);
  msec -= mm * 1000 * 60;
  var ss = Math.floor(msec / 1000);
  msec -= ss * 1000;

  let mmm = mm >= 10 ? mm : '0' + mm;
  let hhh = hh >= 10 ? hh : '0' + hh;
  let sss = ss >= 10 ? ss : '0' + ss;

  return hhh + ":" + mmm + ":" + sss;

};

module.exports.sectotime = (secs) => {
  var condate = new Date(0);
  condate.setSeconds(secs);
  return condate.toISOString().substring(11, 19);

};

module.exports.timetodec = (time) => {

  let [h, m, s] = String(time).split(/[.:]/);
  h = h || 0;
  return Number((+h + +m / 60 + +s / 3600).toFixed(2));
};

module.exports.dectotime = (num) => {
  var hours = Math.floor(num / 60);
  if (hours < 10) hours = '0' + hours;
  var minutes = Math.round(num % 60);
  if (minutes < 10) minutes = '0' + minutes;
  return hours + ":" + minutes + ":00";
};
module.exports.timeconvert = (num) => {

  var hours = (num / 60);
  var rhours = Math.floor(hours);
  if (rhours < 10) rhours = '0' + rhours;
  var minutes = (hours - rhours) * 60;
  var rminutes = Math.round(minutes);
  if (rminutes < 10) rminutes = '0' + rminutes;
  return rhours + ":" + rminutes + ":00";
};

module.exports.calavg = (array) => {
  var total = 0;
  var count = 0;

  array.forEach(function (item, index) {
    total += item;
    count++;
  });

  return total / count;
}

module.exports.breaktimecalculate = async(array) => {

  // console.log(array);
  const moment = require("moment");
  let finaltime = await array.map((item)=>{
    let date1 = new Date(moment(item.date).format("YYYY-MM-DD") +" " +item.start_time);
    let date2 = new Date(moment(item.date).format("YYYY-MM-DD") +" " +item.end_time);
    
    let diff = date2.getTime() - date1.getTime();
    
    let msec = diff;
    let hh = Math.floor(msec / 1000 / 60 / 60);
    msec -= hh * 1000 * 60 * 60;
  
    let mm = Math.floor(msec / 1000 / 60);
    msec -= mm * 1000 * 60;
    let ss = Math.floor(msec / 1000);
    msec -= ss * 1000;
  
    let mmm = mm >= 10 ? mm : '0' + mm;
    let hhh = hh >= 10 ? hh : '0' + hh;
    let sss = ss >= 10 ? ss : '0' + ss;
  
    return this.timetodec(hhh + ":" + mmm + ":" + sss);
  }).reduce((a,b)=>a+b)
  
  // var msec = finaltime;
  // var hh = Math.floor(msec / 1000 / 60 / 60);
  // console.log(hh);
  // msec -= hh * 1000 * 60 * 60;

  // var mm = Math.floor(msec / 1000 / 60);
  // msec -= mm * 1000 * 60;
  // var ss = Math.floor(msec / 1000);
  // msec -= ss * 1000;

  // let mmm = mm >= 10 ? mm : '0' + mm;
  // let hhh = hh >= 10 ? hh : '0' + hh;
  // let sss = ss >= 10 ? ss : '0' + ss;

  // let difftime = hhh + ":" + mmm + ":" + sss;
  // breaktime:difftime, 
  return {breaktimedec:finaltime}  
}