const nodemailer = require('nodemailer');
const { MAIL_SETTINGS } = require('../constants/constants');
const transporter = nodemailer.createTransport(MAIL_SETTINGS);
require('dotenv').config();

module.exports.sendMail = async (params) => {
  try {
    let info = await transporter.sendMail({
      from: MAIL_SETTINGS.auth.user,
      to: params.to, // list of receivers
      subject: 'Support Ticket Reply : '+params.subject, // Subject line
      html: `
      <div class="container">
        <h4>Support Ticket ID: ${params.uuid}</h4>
        <h4>Support Ticket Reply: ${params.message}</h4>               
      </div>
    `,
    });
    return info;
  } catch (error) {    
    return false;
  }
};
