const nodemailer = require('nodemailer');
const { MAIL_SETTINGS } = require('../constants/constants');
const transporter = nodemailer.createTransport(MAIL_SETTINGS);
require('dotenv').config();

module.exports.sendMail = async (params) => {
  try {
    let info = await transporter.sendMail({
      from: MAIL_SETTINGS.auth.user,
      to: params.to, // list of receivers
      subject: 'Number Renew Reminder', // Subject line
      html: `
      <div class="container">
        <h2>Welcome to the Didbiz.</h2>
        <p>${params.message} : ${params.number}
        </p>        
        <p>${params.comment}.</p>
        
      </div>
    `,
    });
    return info;
  } catch (error) {    
    return false;
  }
};
