const nodemailer = require('nodemailer');
const { MAIL_SETTINGS } = require('../constants/constants');
const transporter = nodemailer.createTransport(MAIL_SETTINGS);
require('dotenv').config();

module.exports.sendMail = async (params) => {
  try {
    let info = await transporter.sendMail({
      from: MAIL_SETTINGS.auth.user,
      to: params.to, // list of receivers
      subject: 'Welcome to Didbiz', // Subject line
      html: `
      <div class="container">
        <h2>Forgot Password.</h2>
        <p>Pleas enter the OTP to Forgot Password: 
        <b style="font-size: 17px">${params.OTP}</b>
        </p>        
        <p><a href='${process.env.SITE_URL}auth/verify-password?id=${encodeURIComponent(params.uuid)}' ><b>Click here</b></a> to verify your account</p>
        <p>If you do not request for verification please do not respond to the mail. </p>
      </div>
    `,
    });
    return info;
  } catch (error) {    
    return false;
  }
};
