const express = require("express");
const router = express.Router();
const con = require("../db/conn").promise();
const {
  timediff,
  sectotime,
  timetodec,
  dectotime,
} = require("../services/Time");
const moment = require("moment");
const authenticate = require("../middleware/authenticate");

router.post("/get-dailyproductivity-report", authenticate, async (req, res) => {
  const { date } = req.body;

  try {
    let sql = `select * FROM attendance_jenyatracking where date ='${date}' and company_uuid='${req.body.uuid}' and is_proj_entry=0`;
    let idlesql = `SELECT * FROM screenshot WHERE date='${date}' AND clicks=0 AND mouseevent=0 AND keyboardevent=0 AND diff_prev_ss!="" AND diff_prev_ss<="00:03:00" and company_uuid='${req.body.uuid}'`;
    let usersql = `SELECT username,name FROM users WHERE active=1 and company_uuid='${req.body.uuid}'`;

    const [userdata] = await con.execute(usersql);
    const [data] = await con.execute(sql);
    const [ssdata] = await con.execute(idlesql);

    let finalarr = [];
    let finalarr1 = [];
    if (userdata.length > 0) {
      userdata.forEach((element) => {
        let timedata = data.filter((item) => {
          return item.username == element.username;
        });

        let idledata = ssdata.filter((item) => {
          return item.username == element.username;
        });

        let totalidle = 0;
        if (idledata.length > 0) {
          let diff = idledata.map((item, i) => {
            return timetodec(item.diff_prev_ss);
          });
          totalidle = diff.reduce((a, b) => a + Number(b), 0);
        }

        if (timedata.length > 0) {
          let diffarr = [];
          timedata.forEach((element1) => {
            let date1 = new Date(
              moment(element1.date).format("YYYY-MM-DD") +
                " " +
                element1.start_time
            );
            let date2 = new Date(
              moment(element1.date).format("YYYY-MM-DD") +
                " " +
                element1.end_time
            );
            let diff;
            if (element1.end_time == "00:00:00") {
              diff = "00:00:00";
            } else {
              diff = timediff(date1, date2);
            }
            let dec = timetodec(diff);
            let obj = {
              prodtime: dec,
            };
            diffarr.push(obj);
          });
          let totaldec = diffarr.reduce((a, b) => a + Number(b.prodtime), 0);
          let idletime = sectotime(totalidle * 60 * 60);

          let workingdec = totaldec - totalidle;
          let tottaldur = dectotime(totaldec * 60);

          let workingdur;
          let prodper;
          if (timedata[timedata.length - 1].end_time == "00:00:00") {
            workingdur = "00:00:00";
            prodper = "0";
          } else {
            workingdur = dectotime(workingdec * 60);
            prodper = ((workingdec * 100) / totaldec).toFixed(2);
          }

          let obj = {
            name: element.name,
            username: element.username,
            punchin: timedata[0].start_time,
            punchout: timedata[timedata.length - 1].end_time,
            status: "Active",
            working: tottaldur,
            idletime: idletime,
            prod: workingdur,
            prodper: prodper + " %",
          };
          let obj1 = {
            Name: element.name,
            Username: element.username,
            "Punch In": timedata[0].start_time,
            "Punch Out": timedata[timedata.length - 1].end_time,
            Status: "Active",
            Working: tottaldur,
            "Idle Time": idletime,
            "Productive Time": workingdur,
            "Productive Percentage": prodper + " %",
          };

          let datewisedata = timedata.filter((item, i) => {
            return moment(item.date).format("YYYY-MM-DD") == date;
          });

          if (datewisedata.length > 0) {
            let diffarr = [];
            datewisedata.forEach((element1) => {
              let date1 = new Date(
                moment(element1.date).format("YYYY-MM-DD") +
                  " " +
                  element1.start_time
              );
              let date2 = new Date(
                moment(element1.date).format("YYYY-MM-DD") +
                  " " +
                  element1.end_time
              );
              let diff;
              if (element1.end_time == "00:00:00") {
                diff = "00:00:00";
              } else {
                diff = timediff(date1, date2);
              }
              let dec = timetodec(diff);
              let obj = {
                prodtime: dec,
              };
              diffarr.push(obj);
            });
            let totaldec = diffarr.reduce((a, b) => a + Number(b.prodtime), 0);
            let tottaldur = dectotime(totaldec * 60);
            obj[date] = tottaldur;
            obj1[date] = tottaldur;
          } else {
            if (
              moment(date).format("YYYY-MM-DD") >=
              moment(new Date()).format("YYYY-MM-DD")
            ) {
              obj[date] = "-";
              obj1[date] = "-";
            } else {
              obj[date] = "A";
              obj1[date] = "A";
              obj.absent = absent++;
              obj1["Absent"] = obj.absent;
            }
          }

          finalarr.push(obj);
          finalarr1.push(obj1);
        }
      });
    }

    if (data.length > 0) {
      res.status(201).json({
        status: 201,
        data: finalarr,
        reparr: finalarr1,
      });
    } else {
      return res.status(200).json({
        status: "422",
        error: "No data available.",
      });
    }
  } catch (err) {
    res.status(500).json({
      error: err,
    });
  }
});

router.post("/get-daywise-appusage-report", authenticate, async (req, res) => {
  const { date, ldate } = req.body;

  try {
    let sql = `SELECT date,username,active_window_details,hours FROM screenshot WHERE date>='${date}' AND date<='${ldate}' and company_uuid='${req.body.uuid}'`;
    let usersql = `SELECT user_id,username,name FROM users WHERE active=1 and company_uuid='${req.body.uuid}'`;

    const [userdata] = await con.execute(usersql);
    const [data] = await con.execute(sql);
    let finalarr = [];
    let finalarr1 = [];
    if (userdata.length > 0) {
      userdata.forEach((element) => {
        if (data.length > 0) {
          let start = new Date(date);
          let end = new Date(ldate);
          let loop = new Date(start);
          while (loop <= end) {
            let date = moment(loop).format("YYYY-MM-DD");

            let appdata = data.filter((item, i) => {
              let idate = moment(item.date).format("YYYY-MM-DD");
              return item.username == element.username && idate == date;
            });

            if (appdata.length > 0) {
              const result = {};
              let totaltime = 0;
              appdata.forEach((element) => {
                let windetails = JSON.parse(element.active_window_details);
                for (const { app, time } of windetails) {
                  if (!result[app]) result[app] = [];
                  result[app].push({
                    time,
                  });
                  totaltime = totaltime + time;
                }
              });

              for (const iterator in result) {
                let sum = result[iterator].reduce((a, b) => a + b.time, 0);
                let obj = {
                  name: element.name,
                  appname: iterator,
                  time: sectotime(sum),
                  date: date,
                };
                let obj1 = {
                  Name: element.name,
                  "App Name": iterator,
                  "App Usage Time": sectotime(sum),
                  Date: date,
                };
                finalarr.push(obj);
                finalarr1.push(obj1);
              }
            }
            let newDate = loop.setDate(loop.getDate() + 1);
            loop = new Date(newDate);
          }
        }
      });
    }
    if (data.length > 0) {
      res.status(201).json({
        status: 201,
        data: finalarr,
        reparr: finalarr1,
      });
    } else {
      return res.status(200).json({
        status: "422",
        error: "No data available.",
      });
    }
  } catch (err) {
    res.status(500).json({
      error: err,
    });
  }
});

router.post("/get-appusage-report", authenticate, async (req, res) => {
  const { date, ldate } = req.body;

  try {
    let sql = `SELECT username,active_window_details,hours FROM screenshot WHERE date>='${date}' AND date<='${ldate}' and company_uuid='${req.body.uuid}'`;
    let usersql = `SELECT user_id,username,name FROM users WHERE active=1 and company_uuid='${req.body.uuid}'`;

    const [userdata] = await con.execute(usersql);
    const [data] = await con.execute(sql);
    let finalarr = [];
    let finalarr1 = [];
    if (userdata.length > 0) {
      userdata.forEach((element) => {
        let appdata = data.filter((item, i) => {
          return item.username == element.username;
        });
        if (appdata.length > 0) {
          const result = {};
          let totaltime = 0;
          appdata.forEach((element) => {
            let windetails = JSON.parse(element.active_window_details);
            for (const { app, time } of windetails) {
              if (!result[app]) result[app] = [];
              result[app].push({
                time,
              });
              totaltime = totaltime + time;
            }
          });

          for (const iterator in result) {
            let sum = result[iterator].reduce((a, b) => a + b.time, 0);
            let obj = {
              name: element.name,
              appname: iterator,
              time: sectotime(sum),
            };
            let obj1 = {
              Name: element.name,
              "App Name": iterator,
              "App Usage Time": sectotime(sum),
            };
            finalarr.push(obj);
            finalarr1.push(obj1);
          }
        }
      });
    }
    if (data.length > 0) {
      res.status(201).json({
        status: 201,
        data: finalarr,
        reparr: finalarr1,
      });
    } else {
      return res.status(200).json({
        status: "422",
        error: "No data available.",
      });
    }
  } catch (err) {
    res.status(500).json({
      error: err,
    });
  }
});

router.post("/get-employee-leavebalance", authenticate, async (req, res) => {
  try {
    let sql = `select name,no FROM leavetype where status=1`;
    let leavesql = `SELECT * FROM user_leaves`;
    let usersql = `SELECT user_id, username,name FROM users WHERE active=1 and company_uuid='${req.body.uuid}' `;

    const [userdata] = await con.execute(usersql);
    const [data] = await con.execute(sql);
    const [stockdata] = await con.execute(leavesql);

    let finalarr = [];
    // let finalarr1 = [];
    if (userdata.length > 0) {
      userdata.forEach((element) => {
        let stocks = stockdata.filter((item, i) => {
          return element.user_id === item.user_id;
        });

        let obj1 = {
          Name: element.name,
          Username: element.username,
        };

        data.forEach((item) => {
          if (item.name == "PL") {
            return;
          }
          let applied = item.no - stocks[0][item.name];
          obj1[item.name] =
            "Stock: " + stocks[0][item.name] + ", Applied: " + applied;
        });
        finalarr.push(obj1);
      });
    }

    if (data.length > 0) {
      res.status(201).json({
        status: 201,
        data: finalarr,
        type: data,
      });
    } else {
      return res.status(200).json({
        status: "422",
        error: "No data available.",
      });
    }
  } catch (err) {
    res.status(500).json({
      error: err,
    });
  }
});

router.post("/get-all-leaves", authenticate, async (req, res) => {
  const { date, ldate } = req.body;

  try {
    let sql = `select * FROM leave_requests_new where start_date >='${date}' and start_date <= '${ldate}' and company_uuid='${req.body.uuid}'`;
    let usersql = `SELECT user_id,username,name FROM users WHERE active=1 and company_uuid='${req.body.uuid}'`;

    const [userdata] = await con.execute(usersql);
    const [data] = await con.execute(sql);
    let finalarr = [];
    let finalarr1 = [];
    if (userdata.length > 0) {
      userdata.forEach((element) => {
        let leavedata = data.filter((item, i) => {
          return item.user_id == element.user_id;
        });
        if (leavedata.length > 0) {
          leavedata.forEach((element1) => {
            let status = "Pending";
            if (element1.hrstatus == 1) {
              status = "Approved";
            }

            let leavedate = moment(element1.start_date).format("YYYY-MM-DD");
            if (element1.noofdays >= 2) {
              leavedate =
                moment(element1.start_date).format("YYYY-MM-DD") +
                " - " +
                moment(element1.end_date).format("YYYY-MM-DD");
            }

            let obj = {
              name: element.name,
              type: element1.leave_type,
              status: status,
              from: leavedate,
              noofdays: element1.noofdays,
              appliedon: moment(element1.request_date).format(
                "YYYY-MM-DD HH:MM:SS"
              ),
            };
            let obj1 = {
              Name: element.name,
              Type: element1.leave_type,
              Status: status,
              From: leavedate,
              "No. of Days": element1.noofdays,
              "Applied On": moment(element1.request_date).format(
                "YYYY-MM-DD HH:MM:SS"
              ),
            };
            finalarr.push(obj);
            finalarr1.push(obj1);
          });
        }
      });
    }

    if (data.length > 0) {
      res.status(201).json({
        status: 201,
        data: finalarr,
        reparr: finalarr1,
      });
    } else {
      return res.status(200).json({
        status: "422",
        error: "No data available.",
      });
    }
  } catch (err) {
    res.status(500).json({
      error: err,
    });
  }
});

router.post("/get-late-mark", authenticate, async (req, res) => {
  const { date, ldate } = req.body;

  try {
    let sql = `select * FROM attendance_jenyatracking where date >='${date}' and date <= '${ldate}' and punching_times=1  and  company_uuid='${req.body.uuid}' and is_proj_entry=0`;
    let usersql = `SELECT username,name FROM users WHERE active=1 and  company_uuid='${req.body.uuid}' `;

    const [userdata] = await con.execute(usersql);
    const [data] = await con.execute(sql);

    let finalarr = [];
    let finalarr1 = [];
    if (userdata.length > 0) {
      userdata.forEach((element) => {
        let timedata = data.filter((item, i) => {
          return item.username == element.username;
        });

        if (timedata.length > 0) {
          timedata.forEach((element1) => {
            let date1 = new Date(
              moment(element1.date).format("YYYY-MM-DD") +
                " " +
                element1.start_time
            );
            let date2 = new Date(
              moment(element1.date).format("YYYY-MM-DD") + " 09:10:00"
            );
            let diff;
            if (element1.end_time == "00:00:00") {
              diff = "-";
            } else {
              if (date2 <= date1) {
                diff = timediff(date2, date1);
              } else {
                diff = "-";
              }
            }

            let obj = {
              name: element.name,
              username: element.username,
              punchin: element1.start_time,
              late: diff,
              date: moment(element1.date).format("YYYY-MM-DD"),
            };
            let obj1 = {
              Name: element.name,
              Username: element.username,
              "Punch In": element.start_time,
              Late: diff,
              date: moment(element1.date).format("YYYY-MM-DD"),
            };
            finalarr.push(obj);
            finalarr1.push(obj1);
          });
        }
      });
    }

    if (data.length > 0) {
      res.status(201).json({
        status: 201,
        data: finalarr,
        reparr: finalarr1,
      });
    } else {
      return res.status(200).json({
        status: "422",
        error: "No data available.",
      });
    }
  } catch (err) {
    res.status(500).json({
      error: err,
    });
  }
});

router.post(
  "/get-attendance-regularization",
  authenticate,
  async (req, res) => {
    const { date, ldate } = req.body;

    try {
      let sql = `select * FROM attendance_jenyatracking where date >='${date}' and date <= '${ldate}' and company_uuid='${req.body.uuid}'  and is_proj_entry=0`;
      let idlesql = `SELECT * FROM screenshot WHERE date>='${date}' and date<='${ldate}' AND clicks=0 AND mouseevent=0 AND keyboardevent=0 AND diff_prev_ss!="" AND diff_prev_ss<="00:03:00" and company_uuid='${req.body.uuid}'`;
      let usersql = `SELECT username,name FROM users WHERE active=1 and company_uuid='${req.body.uuid}'`;

      const [userdata] = await con.execute(usersql);
      const [data] = await con.execute(sql);
      const [ssdata] = await con.execute(idlesql);

      let finalarr = [];
      let finalarr1 = [];
      if (userdata.length > 0) {
        userdata.forEach((element) => {
          let timedata = data.filter((item, i) => {
            return item.username == element.username;
          });

          let idledata = ssdata.filter((item, i) => {
            return item.username == element.username;
          });

        //   let totalidle = 0;
          if (idledata.length > 0) {
            let diff = idledata.map((item, i) => {
              return timetodec(item.diff_prev_ss);
            });
            totalidle = diff.reduce((a, b) => a + Number(b), 0);
          }

          if (timedata.length > 0) {
            let start = new Date(date);
            let end = new Date(ldate);
            let loop = new Date(start);
            while (loop <= end) {
              let date = moment(loop).format("YYYY-MM-DD");

              let datewisedata = timedata.filter((item, i) => {
                return moment(item.date).format("YYYY-MM-DD") == date;
              });

              if (datewisedata.length > 0) {
                let diffarr = [];
                datewisedata.forEach((element1) => {
                  let date1 = new Date(
                    moment(element1.date).format("YYYY-MM-DD") +
                      " " +
                      element1.start_time
                  );
                  let date2 = new Date(
                    moment(element1.date).format("YYYY-MM-DD") +
                      " " +
                      element1.end_time
                  );
                  let diff;
                  if (element1.end_time == "00:00:00") {
                    diff = "00:00:00";
                  } else {
                    diff = timediff(date1, date2);
                  }
                  let dec = timetodec(diff);
                  let obj = {
                    prodtime: dec,
                  };
                  diffarr.push(obj);
                });
                let totaldec = diffarr.reduce(
                  (a, b) => a + Number(b.prodtime),
                  0
                );
                let tottaldur = dectotime(totaldec * 60);

                let obj = {
                  name: element.name,
                  username: element.username,
                  status: "Approved",
                  working: tottaldur,
                  date: date,
                };
                let obj1 = {
                  Name: element.name,
                  Username: element.username,
                  Status: "Approved",
                  Working: tottaldur,
                  date: date,
                };
                finalarr.push(obj);
                finalarr1.push(obj1);
              }

              let newDate = loop.setDate(loop.getDate() + 1);
              loop = new Date(newDate);
            }
          }
        });
      }

      if (data.length > 0) {
        res.status(201).json({
          status: 201,
          data: finalarr,
          reparr: finalarr1,
        });
      } else {
        return res.status(200).json({
          status: "422",
          error: "No data available.",
        });
      }
    } catch (err) {
      res.status(500).json({
        error: err,
      });
    }
  }
);

router.post("/get-datewise-attreport", authenticate, async (req, res) => {
  const { date, ldate } = req.body;

  try {
    let sql = `select * FROM attendance_jenyatracking where date >='${date}' and date <= '${ldate}' and company_uuid='${req.body.uuid}'  and is_proj_entry=0`;
    let idlesql = `SELECT * FROM screenshot WHERE date>='${date}' and date<='${ldate}' AND clicks=0 AND mouseevent=0 AND keyboardevent=0 AND diff_prev_ss!="" AND diff_prev_ss<="00:03:00" and company_uuid='${req.body.uuid}'`;
    let usersql = `SELECT username,name FROM users WHERE active=1 and company_uuid='${req.body.uuid}'`;

    const [userdata] = await con.execute(usersql);
    const [data] = await con.execute(sql);
    const [ssdata] = await con.execute(idlesql);

    let finalarr = [];
    let finalarr1 = [];
    if (userdata.length > 0) {
      userdata.forEach((element) => {
        let timedata = data.filter((item, i) => {
          return item.username == element.username;
        });

        let idledata = ssdata.filter((item, i) => {
          return item.username == element.username;
        });

        let totalidle = 0;
        if (idledata.length > 0) {
          let diff = idledata.map((item, i) => {
            return timetodec(item.diff_prev_ss);
          });
          totalidle = diff.reduce((a, b) => a + Number(b), 0);
        }

        if (timedata.length > 0) {
          let diffarr = [];
          timedata.forEach((element1) => {
            let date1 = new Date(
              moment(element1.date).format("YYYY-MM-DD") +
                " " +
                element1.start_time
            );
            let date2 = new Date(
              moment(element1.date).format("YYYY-MM-DD") +
                " " +
                element1.end_time
            );
            let diff;
            if (element1.end_time == "00:00:00") {
              diff = "00:00:00";
            } else {
              diff = timediff(date1, date2);
            }
            let dec = timetodec(diff);
            let obj = {
              prodtime: dec,
            };
            diffarr.push(obj);
          });
          let totaldec = diffarr.reduce((a, b) => a + Number(b.prodtime), 0);
          let idletime;
          if(isNaN(totalidle)==false){
            idletime = sectotime(totalidle * 60 * 60);
          }else{
            idletime = "00:00:00";
          }

          let workingdec = totaldec - totalidle;
          let tottaldur = dectotime(totaldec * 60);

          let workingdur = dectotime(workingdec * 60);
          let prodper = ((workingdec * 100) / totaldec).toFixed(2);

          let obj = {
            name: element.name,
            username: element.username,
            status: "Active",
            working: tottaldur,
            idletime: idletime,
            prod: workingdur,
            prodper: prodper + " %",
          };
          let obj1 = {
            Name: element.name,
            Username: element.username,
            Status: "Active",
            Working: tottaldur,
            "Idle Time": idletime,
            "Productive Time": workingdur,
            "Productive Percentage": prodper + " %",
          };

          let start = new Date(date);
          let end = new Date(ldate);
          let loop = new Date(start);
          let absent = 1;
          while (loop <= end) {
            let date = moment(loop).format("YYYY-MM-DD");

            let datewisedata = timedata.filter((item, i) => {
              return moment(item.date).format("YYYY-MM-DD") == date;
            });

            if (datewisedata.length > 0) {
              let diffarr = [];
              datewisedata.forEach((element1) => {
                let date1 = new Date(
                  moment(element1.date).format("YYYY-MM-DD") +
                    " " +
                    element1.start_time
                );
                let date2 = new Date(
                  moment(element1.date).format("YYYY-MM-DD") +
                    " " +
                    element1.end_time
                );
                let diff;
                if (element1.end_time == "00:00:00") {
                  diff = "00:00:00";
                } else {
                  diff = timediff(date1, date2);
                }
                let dec = timetodec(diff);
                let obj = {
                  prodtime: dec,
                };
                diffarr.push(obj);
              });
              let totaldec = diffarr.reduce(
                (a, b) => a + Number(b.prodtime),
                0
              );
              let tottaldur = dectotime(totaldec * 60);
              obj[date] = tottaldur;
              obj1[date] = tottaldur;
            } else {
              if (
                moment(date).format("YYYY-MM-DD") >=
                moment(new Date()).format("YYYY-MM-DD")
              ) {
                obj[date] = "-";
                obj1[date] = "-";
              } else {
                obj[date] = "A";
                obj1[date] = "A";
                obj.absent = absent++;
                obj1["Absent"] = obj.absent;
              }
            }

            let newDate = loop.setDate(loop.getDate() + 1);
            loop = new Date(newDate);
          }

          finalarr.push(obj);
          finalarr1.push(obj1);
        }
      });
    }

    let start = new Date(date);
    let end = new Date(ldate);
    let loop = new Date(start);
    let datearr = [];
    while (loop <= end) {
      let date = moment(loop).format("YYYY-MM-DD");
      datearr.push(date);
      let newDate = loop.setDate(loop.getDate() + 1);
      loop = new Date(newDate);
    }

    if (data.length > 0) {
      res.status(201).json({
        status: 201,
        data: finalarr,
        datearr: datearr,
        reparr: finalarr1,
      });
    } else {
      return res.status(200).json({
        status: "422",
        error: "No data available.",
      });
    }
  } catch (err) {
    console.log(err);
    res.status(500).json({
      error: err,
    });
  }
});

router.post("/get-monthwise-attreport", authenticate, async (req, res) => {
  const { username, date, ldate } = req.body;

  try {
    let sql = `select * FROM attendance_jenyatracking where date >='${date}' and date <= '${ldate}' and company_uuid='${req.body.uuid}'  and is_proj_entry=0`;
    let idlesql = `SELECT * FROM screenshot WHERE date>='${date}' and date<='${ldate}' AND clicks=0 AND mouseevent=0 AND keyboardevent=0 AND diff_prev_ss!="" AND diff_prev_ss<="00:03:00" and company_uuid='${req.body.uuid}'`;
    let leavesql = `SELECT user_id,noofdays FROM leave_requests_new WHERE start_date>='${date}' and start_date<='${ldate}' and company_uuid='${req.body.uuid}'`;

    let usersql;
    if (username != "") {
      usersql = `SELECT uuid, user_id,username,name FROM users WHERE active=1 and username='${username}' and company_uuid='${req.body.uuid}' `;
    } else {
      usersql = `SELECT uuid, user_id,username,name FROM users WHERE active=1 and company_uuid='${req.body.uuid}'`;
    }

    let holidaysql = `SELECT * FROM holidays WHERE date>='${date}' and date<='${ldate}' and uuid='${req.body.uuid}'`;

    const [userdata] = await con.execute(usersql);
    const [data] = await con.execute(sql);
    const [ssdata] = await con.execute(idlesql);
    const [leavedata] = await con.execute(leavesql);
    const [holidaydata] = await con.execute(holidaysql);

    let finalarr = [];
    let finalarr1 = [];
    if (userdata.length > 0) {
      userdata.forEach((element) => {
        let timedata = data.filter((item, i) => {
          return item.username == element.username;
        });

        let idledata = ssdata.filter((item, i) => {
          return item.username == element.username;
        });

        let leaves = leavedata.filter((item, i) => {
          return item.user_id == element.user_id;
        });

        let totalidle = 0;
        if (idledata.length > 0) {
          let diff = idledata.map((item, i) => {
            return timetodec(item.diff_prev_ss);
          });
          totalidle = diff.reduce((a, b) => a + Number(b), 0);
        }

        if (timedata.length > 0) {
          let diffarr = [];
          timedata.forEach((element1) => {
            let date1 = new Date(
              moment(element1.date).format("YYYY-MM-DD") +
                " " +
                element1.start_time
            );
            let date2 = new Date(
              moment(element1.date).format("YYYY-MM-DD") +
                " " +
                element1.end_time
            );
            let diff;
            if (element1.end_time == "00:00:00") {
              diff = "00:00:00";
            } else {
              diff = timediff(date1, date2);
            }
            let dec = timetodec(diff);
            let obj = {
              prodtime: dec,
            };
            diffarr.push(obj);
          });
          let totaldec = diffarr.reduce((a, b) => a + Number(b.prodtime), 0);
        //   let idletime = sectotime(totalidle * 60 * 60);

          let workingdec = totaldec - totalidle;
        //   let tottaldur = dectotime(totaldec * 60);

        //   let workingdur = dectotime(workingdec * 60);
        //   let prodper = ((workingdec * 100) / totaldec).toFixed(2);

          let totalleaves = leaves.reduce((a, b) => a + Number(b.noofdays), 0);
          let halfdayleavesdata = leaves.filter(
            (item, i) => item.noofdays == Number("0.5")
          );
          let halfdayleaves = halfdayleavesdata.reduce(
            (a, b) => a + Number(b.noofdays),
            0
          );
          let obj = {
            uuid: element.uuid,
            name: element.name,
            username: element.username,
            status: "Active",

            leaves: totalleaves,
            halfdayleaves: halfdayleaves,
            holidays: holidaydata.length,
          };
          let obj1 = {
            uuid: element.uuid,
            Name: element.name,
            Username: element.username,

            "Total Leaves": totalleaves,
            "HalfDay Leaves": halfdayleaves,
            Holidays: holidaydata.length,
          };

          let start = new Date(date);
          let end = new Date(ldate);
          let loop = new Date(start);
          let absent = 1;
          let present = 1;
          while (loop <= end) {
            let date = moment(loop).format("YYYY-MM-DD");

            let datewisedata = timedata.filter((item, i) => {
              return moment(item.date).format("YYYY-MM-DD") == date;
            });

            if (datewisedata.length > 0) {
              let diffarr = [];
              datewisedata.forEach((element1) => {
                let date1 = new Date(
                  moment(element1.date).format("YYYY-MM-DD") +
                    " " +
                    element1.start_time
                );
                let date2 = new Date(
                  moment(element1.date).format("YYYY-MM-DD") +
                    " " +
                    element1.end_time
                );
                let diff;
                if (element1.end_time == "00:00:00") {
                  diff = "00:00:00";
                } else {
                  diff = timediff(date1, date2);
                }
                let dec = timetodec(diff);
                let obj = {
                  prodtime: dec,
                };
                diffarr.push(obj);
              });
              let totaldec = diffarr.reduce(
                (a, b) => a + Number(b.prodtime),
                0
              );
              let tottaldur = dectotime(totaldec * 60);

              obj[date] = "P";
              obj1[date] = "P";
              obj.present = present++;
              obj1["Present"] = obj.present;
            } else {
              if (
                moment(date).format("YYYY-MM-DD") >=
                moment(new Date()).format("YYYY-MM-DD")
              ) {
                obj[date] = "-";
                obj1[date] = "-";
              } else {
                obj[date] = "AB";
                obj1[date] = "AB";
                obj.absent = absent++;
                obj1["Absent"] = obj.absent;
              }
            }

            let newDate = loop.setDate(loop.getDate() + 1);
            loop = new Date(newDate);
          }

          finalarr.push(obj);
          finalarr1.push(obj1);
        }
      });
    }

    let start = new Date(date);
    let end = new Date(ldate);
    let loop = new Date(start);
    let datearr = [];
    while (loop <= end) {
      let date = moment(loop).format("YYYY-MM-DD");

      
      datearr.push(date);
      let newDate = loop.setDate(loop.getDate() + 1);
      loop = new Date(newDate);
    }

    if (data.length > 0) {
      res.status(201).json({
        status: 201,
        data: finalarr,
        datearr: datearr,
        reparr: finalarr1,
      });
    } else {
      return res.status(200).json({
        status: "422",
        error: "No data available.",
      });
    }
  } catch (err) {
    // console.log(err);
    res.status(500).json({
      error: err,
    });
  }
});

module.exports = router;
