const express = require("express");
const router = express.Router();
const con = require("../db/conn").promise();
const {
  breaktimecalculate,
  timediff,
  sectotime,
  timetodec,
  dectotime,
  timeconvert,
} = require("../services/Time");
const moment = require("moment");
const authenticate = require("../middleware/authenticate");
let { duration } = require("moment");

router.post("/get-allusers", authenticate, async (req, res) => {
  try {
    const [row] = await con.execute(
      "SELECT user_id,username,name,avatar from users where `active`=1"
    );

    if (row.length > 0) {
      res.status(201).json({
        status: 201,
        data: row,
      });
    } else {
      return res.status(200).json({
        status: "422",
        error: "No data available.",
      });
    }
  } catch (err) {
    res.status(500).json({
      error: err,
    });
  }
});

router.post("/get-screenshotData", authenticate, async (req, res) => {
  const { username, date, company_uuid, master } = req.body;

  try {
    let where="";
    // if(master==1){
        where = `and company_uuid='${company_uuid}'`
    // }
    let sql = `SELECT * FROM screenshot WHERE username='${username}'  AND date = '${date}' ${where}`;
    // console.log(sql);
    const [result1] = await con.execute(sql);

    const result = {};

    for (const {
      id,
      username,
      date,
      hours,
      time,
      image_name,
      active_window,
      active_window_details,
      clicks,
      mouseevent,
      keyboardevent,
      diff_prev_ss,
      proj_id,
      act_id,
      memo
    } of result1) {
      if (!result[hours]) result[hours] = [];
      // console.log(proj_id,
      //   act_id,
      //   memo);]
      let project="";
      if(proj_id!=0){
        let projsql = `SELECT name FROM projects WHERE project_id='${proj_id}'`;
        const [projname] = await con.execute(projsql);
        project = projname[0]?.name
      }
      let activity="";
      if(act_id!=0){
        let actsql = `SELECT activity_name FROM project_activity WHERE activity_id='${act_id}'`;
        // console.log(actsql);
        const [actdata] = await con.execute(actsql);
        activity = actdata[0]?.activity_name
      }

      result[hours].push({
        id,
        username,
        date,
        hours,
        time,
        image_name,
        active_window,
        active_window_details,
        clicks,
        mouseevent,
        keyboardevent,
        diff_prev_ss,
        project,
        activity,
        memo
      });
    }

    let sql2 = `SELECT * FROM activewin_icons`;

    const [iconsresults] = await con.execute(sql2);

    if (result1.length > 0) {
      res.status(201).json({
        status: 201,
        data: result,
        icons: iconsresults,
      });
    } else {
      return res.status(200).json({
        status: "422",
        error: "No data available.",
      });
    }
  } catch (err) {
    res.status(500).json({
      error: err,
    });
  }
});

router.post("/get-AppData", authenticate, async (req, res) => {
  const { username, date, ldate, company_uuid, master } = req.body;

  try {
    let sql;
    let where="";
    // if(master==1){
        where = `and company_uuid='${company_uuid}'`
    // }
    if (ldate == undefined) {
      sql = `SELECT active_window_details,hours FROM screenshot WHERE username='${username}'  AND date='${date}' ${where}`;
    } else if (username == "") {
      sql = `SELECT active_window_details,hours FROM screenshot WHERE date>='${date}' AND date<='${ldate}' ${where}`;
    } else {
      sql = `SELECT active_window_details,hours FROM screenshot WHERE username='${username}'  AND date>='${date}' AND date<='${ldate}' ${where}`;
    }

    const [results] = await con.execute(sql);

    if (results.length > 0) {
      const result = {};
      let totaltime = 0;
      results.forEach((element) => {
        let windetails = JSON.parse(element.active_window_details);
        for (const { app, time } of windetails) {
          if (!result[app]) result[app] = [];
          result[app].push({
            time,
          });
          totaltime = totaltime + time;
        }
      });

      let sql = `SELECT * FROM activewin_icons`;
      const [iconsresults] = await con.execute(sql);

      let finalarr = [];
      for (const iterator in result) {
        let sum = result[iterator].reduce((a, b) => a + b.time, 0);

        let icon = iconsresults.filter((item, i) => {
          return item.app_name == iterator;
        });

        let obj = {
          appname: iterator,
          icon: icon.length > 0 ? icon[0].icon : null,
          icon_id: icon.length > 0 ? icon[0].id : null,
          time: sum,
          usage: ((sum * 100) / totaltime).toFixed(2),
          is_productive:
            icon.length > 0 && icon[0].is_productive == 1
              ? "Productive"
              : "Unproductive",
        };
        finalarr.push(obj);
      }

      let arr = finalarr
        .sort(function (a, b) {
          return b.time - a.time;
        })
        .filter(function (a, b, c) {
          return !b || c[b - 1].time != a.time;
        });

      res.status(201).json({
        status: 201,
        data: arr,
      });
    } else {
      return res.status(200).json({
        status: "422",
        error: "No data available.",
      });
    }
  } catch (err) {
    res.status(500).json({
      error: err,
    });
  }
});

router.post("/get-AppChartData", authenticate, async (req, res) => {
  const { username, date, uuid } = req.body;

  try {
    let sql = `SELECT active_window_details,hours FROM screenshot WHERE username='${username}'  AND date='${date}'`;
    const [results] = await con.execute(sql);

    if (results.length > 0) {
      const result = {};
      let totaltime = 0;
      results.forEach((element) => {
        let windetails = JSON.parse(element.active_window_details);
        for (const { app, time } of windetails) {
          if (!result[app]) result[app] = [];
          result[app].push({
            time,
          });
          totaltime = totaltime + time;
        }
      });

      let finalarr = [];
      for (const iterator in result) {
        let sum = result[iterator].reduce((a, b) => a + b.time, 0);

        let obj = {
          appname: iterator,
          time: sum,
          usage: ((sum * 100) / totaltime).toFixed(2),
        };
        finalarr.push(obj);
      }

      let arr = finalarr
        .sort(function (a, b) {
          return b.time - a.time;
        })
        .filter(function (a, b, c) {
          return !b || c[b - 1].time != a.time;
        });

      let hourarr = [];
      let finalarr1 = [];
      for (let index = 0; index <= 23; index++) {
        let filterappdata = results.filter((item, i) => {
          return item.hours == index;
        });

        const result = {};
        let totaltime = 0;
        filterappdata.forEach((element, i) => {
          let windetails = JSON.parse(element.active_window_details);
          for (const { app, time } of windetails) {
            if (!result[app]) result[app] = [];
            result[app].push({
              time,
            });
            totaltime = totaltime + time;
          }
        });

        for (const iterator in result) {
          let sum = result[iterator].reduce((a, b) => a + b.time, 0);
          let obj = {
            appname: iterator,
            time: sum,
            hours: index,
          };
          finalarr1.push(obj);
        }
        hourarr.push(index + ":00");
      }

      let first3apps = arr.slice(0, 3);
      let topapps = [];
      first3apps.forEach((element) => {
        topapps.push(element.appname);
      });

      let result2 = [];
      finalarr1.forEach((element, i) => {
        if (!result2[element.appname]) result2[element.appname] = [];
        result2[element.appname].push({
          time: element.time,
          hours: element.hours,
        });
      });

      let apphourwisearr = [];
      for (const iterator in result2) {
        if (topapps.includes(iterator)) {
          let data = [];
          let data1 = [];
          for (const iterator1 of result2[iterator]) {
            data.push(Math.floor(iterator1.time / 60));
            data1.push(Math.floor(iterator1.hours));
          }

          let finaldata = [];
          for (let index = 0; index <= 23; index++) {
            if (data1.includes(index)) {
              let index1 = data1.indexOf(index);
              finaldata.push(data[index1]);
            } else {
              finaldata.push(0);
            }
          }
          apphourwisearr.push({
            name: iterator,
            data: finaldata,
          });
        }
      }

      res.status(201).json({
        status: 201,
        apphourwisearr: apphourwisearr,
        hourarr: hourarr,
      });
    } else {
      return res.status(200).json({
        status: "422",
        error: "No data available.",
      });
    }
  } catch (err) {
    res.status(500).json({
      error: err,
    });
  }
});

router.post("/get-AppChartDateWiseData", authenticate, async (req, res) => {
  const { username, date, ldate ,company_uuid,master} = req.body;
  try {
    let where="";
    // if(master==1){
        where = `and company_uuid='${company_uuid}'`
    // }
    let sql = `SELECT active_window_details,date FROM screenshot WHERE username='${username}' AND date>='${date}' AND date<='${ldate}' ${where}`;
    const [results] = await con.execute(sql);

    if (results.length > 0) {
      const result = {};
      let totaltime = 0;
      results.forEach((element) => {
        let windetails = JSON.parse(element.active_window_details);
        for (const { app, time } of windetails) {
          if (!result[app]) result[app] = [];
          result[app].push({
            time,
          });
          totaltime = totaltime + time;
        }
      });

      let finalarr = [];
      for (const iterator in result) {
        let sum = result[iterator].reduce((a, b) => a + b.time, 0);

        let obj = {
          appname: iterator,
          time: sum,
          date: sum,
          usage: ((sum * 100) / totaltime).toFixed(2),
        };
        finalarr.push(obj);
      }

      let arr = finalarr
        .sort(function (a, b) {
          return b.time - a.time;
        })
        .filter(function (a, b, c) {
          return !b || c[b - 1].time != a.time;
        });

      let datearr = [];
      let finalarr1 = [];

      let start = new Date(date);
      let end = new Date(ldate);
      let loop = new Date(start);
      while (loop <= end) {
        let date = moment(loop).format("YYYY-MM-DD");
        let filterappdata = results.filter((item, i) => {
          return moment(item.date).format("YYYY-MM-DD") == date;
        });

        const result = {};
        let totaltime = 0;
        filterappdata.forEach((element, i) => {
          let windetails = JSON.parse(element.active_window_details);
          for (const { app, time } of windetails) {
            if (!result[app]) result[app] = [];
            result[app].push({
              time,
            });
            totaltime = totaltime + time;
          }
        });

        for (const iterator in result) {
          let sum = result[iterator].reduce((a, b) => a + b.time, 0);
          let obj = {
            appname: iterator,
            time: sum,
            date: date,
          };
          finalarr1.push(obj);
        }

        datearr.push(date);
        let newDate = loop.setDate(loop.getDate() + 1);
        loop = new Date(newDate);
      }

      let first3apps = arr.slice(0, 3);

      let topapps = [];
      first3apps.forEach((element) => {
        topapps.push(element.appname);
      });

      let result2 = [];
      finalarr1.forEach((element, i) => {
        if (!result2[element.appname]) result2[element.appname] = [];
        result2[element.appname].push({
          time: element.time,
          date: element.date,
        });
      });

      let apphourwisearr = [];
      for (const iterator in result2) {
        if (topapps.includes(iterator)) {
          let data = [];
          let data1 = [];
          for (const iterator1 of result2[iterator]) {
            data.push(Math.floor(iterator1.time / 60));
            data1.push(iterator1.date);
          }

          let finaldata = [];
          let start = new Date(date);
          let end = new Date(ldate);
          let loop = new Date(start);
          while (loop <= end) {
            let date = moment(loop).format("YYYY-MM-DD");
            if (data1.includes(date)) {
              let index1 = data1.indexOf(date);
              finaldata.push(data[index1]);
            } else {
              finaldata.push(0);
            }
            let newDate = loop.setDate(loop.getDate() + 1);
            loop = new Date(newDate);
          }
          apphourwisearr.push({
            name: iterator,
            data: finaldata,
          });
        }
      }

      res.status(201).json({
        status: 201,
        apphourwisearr: apphourwisearr,
        datearr: datearr,
      });
    } else {
      return res.status(200).json({
        status: "422",
        error: "No data available.",
      });
    }
  } catch (err) {
    res.status(500).json({
      error: err,
    });
  }
});

router.post("/get-Summary", authenticate, async (req, res) => {
  let { username, date, company_uuid, master } = req.body;
  date = date.substring(0,10);

  try {
    let sql;
    let sql2;
    let where="";
    // if(master==1){
        where = `and company_uuid='${company_uuid}'`
    // }
    if (!username) {
      sql = `SELECT * FROM attendance_jenyatracking WHERE  date='${date}' ${where} and is_proj_entry=0`;
      sql2 = `SELECT * FROM screenshot WHERE date ='${date}' AND clicks=0 AND mouseevent=0 AND keyboardevent=0 AND diff_prev_ss!="" AND diff_prev_ss<="00:03:00" and  ${where}`;
      breaksql = `select date,start_time,end_time FROM attendance_breaks_jenyatracking where date = '${date}' and end_time!='00:00:00' ${where}`;
    } else {
      sql = `SELECT * FROM attendance_jenyatracking WHERE username= '${username}' AND date='${date}' ${where}  and is_proj_entry=0`;
      sql2 = `SELECT * FROM screenshot WHERE date ='${date}' AND clicks=0 AND mouseevent=0 AND keyboardevent=0 and username= '${username}'  AND diff_prev_ss!="" AND diff_prev_ss<="00:03:00" ${where}`;
      breaksql = `select date,start_time,end_time FROM attendance_breaks_jenyatracking where date = '${date}' and username= '${username}' and end_time!='00:00:00' ${where}`;
    }

    // console.log(sql2);

    const [attdata] = await con.execute(sql);
    const [idledatadata] = await con.execute(sql2);
    const [breakdata] = await con.execute(breaksql);
    // console.log(breakdata);
    let totalbreaktime = 0;
    if(breakdata.length>0){
     totalbreaktime = (await breaktimecalculate(breakdata)).breaktimedec;
    }
    // console.log(totalbreaktime);
    let arr = [];
    if (attdata && attdata.length > 0) {
      // let last_out = attdata[attdata.length - 1].end_time;
      // if (last_out != "00:00:00") {
      //   duration = timediff(
      //     date + " " + attdata[0].start_time,
      //     date + " " + last_out
      //   );
      // } else {
      //   duration = "00:00:00";
      // }
      let totaldec=0;
      if (attdata.length > 0) {
        let diffarr = [];
        attdata.forEach((element1) => {
            let date1 = new Date(
                moment(element1.date).format("YYYY-MM-DD") +
                " " +
                element1.start_time
            );
            let date2 = new Date(
                moment(element1.date).format("YYYY-MM-DD") + " " + element1.end_time
            );
            let diff;
            if (element1.end_time == "00:00:00") {
                diff = "00:00:00";
            } else {
                diff = timediff(date1, date2);
            }
            let dec = timetodec(diff);
            let obj = {
                prodtime: dec,
            };
            diffarr.push(obj);
        });

        totaldec = await diffarr.reduce(
            (a, b) => a + Number(b.prodtime),
            0
        );
        // console.log(totaldec);
      }   
      let durationdec = totaldec-(totalbreaktime);
      // console.log(totalbreaktime);
      if(durationdec<0){
        durationdec = 0;
      }
      let duration = dectotime(durationdec *60);
     
      // console.log(duration);
      // console.log(duration);
      // return
      // let sql;
      // if (!username) {
      //   sql = `SELECT * FROM attendance_jenyatracking WHERE  date='${date}' ${where}`;
      // } else { 
      //   sql = `SELECT * FROM attendance_jenyatracking WHERE username= '${username}'  AND date='${date}' ${where}`;
      // }
      // console.log(sql);

      // const [ssdata] = await con.execute(sql);
      let prodtime;
      let idletime;
      let prodper;
      if (idledatadata.length > 0 ) {
        // idletime = sectotime(ssdata.length * 120);
        let idledata = idledatadata.filter((item, i) => {
          return item.username == username;
        });

        // console.log(idledata);
        
        let totalidle = 0;
        if (idledata.length > 0) {
          let diff = idledata.map((item, i) => {
            return timetodec(item.diff_prev_ss);
          });
          totalidle = diff.reduce((a, b) => a + Number(b), 0);
        }

        // console.log(totalidle);
      
        if(isNaN(totalidle)==false){
          idletime = dectotime(totalidle * 60);
        }else{
          idletime = "00:00:00";
        }
        if(duration != "00:00:00"){
          prodtime = timediff(date + " " + idletime, date + " " + duration);
        }else{
          prodtime = "00:00:00";
        }
        let durationdec = timetodec(duration);
        proddec = timetodec(prodtime);
        prodper = ((proddec * 100) / durationdec).toFixed(2);
      } else {
        prodtime = "00:00:00";
        idletime = "00:00:00";
        prodper = "0%";
      }
      // console.log(attdata);
      arr = [
        {
          in: attdata[0].start_time,
          out: attdata[attdata.length-1].end_time,
          duration: duration,
          prodtime: prodtime,
          idletime: idletime,
          prodper: (isNaN(prodper)==false)?prodper:"0%",
        },
      ];
    }
    let date1 = new Date(date);
    date1.setDate(date1.getDate() - 7);
    let lastweekdate = date1.toISOString().substring(0, 10);

    let weekduration;
    let weeksql = `SELECT * FROM attendance_jenyatracking WHERE username='${username}' AND date>='${lastweekdate}' and date<='${date}' and is_proj_entry=0 ${where}`;
    const [weekattdata] = await con.execute(weeksql);

    if (weekattdata && weekattdata.length > 0) {
      let weeklast_out = await weekattdata[weekattdata.length - 1].end_time;
      if (weeklast_out != "00:00:00") {
        weekduration = timediff(
          date + " " + weekattdata[0].start_time,
          date + " " + weeklast_out
        );
      } else {
        weekduration = "00:00:00";
      }
    } else {
      weekduration = "00:00:00";
    }

    let weeklyarr = [];
    let weekarr = [];
    if (weekattdata.length > 0) {
      let weeksql = `SELECT * FROM screenshot WHERE username= '${username}'  AND date>='${lastweekdate}' and date<='${date}' AND clicks=0 AND mouseevent=0 AND keyboardevent=0 AND diff_prev_ss!="" AND diff_prev_ss<="00:03:00" ${where}`;
      const [weekata] = await con.execute(weeksql);
      let idletime = "00:00:00";
      let totalidle = 0;
      if(weekata.length>0){       
        if (weekata.length > 0) {
          let diff = weekata.map((item, i) => {
            return timetodec(item.diff_prev_ss);
          });
          totalidle = diff.reduce((a, b) => a + Number(b), 0);
        }
        if(isNaN(totalidle)==false){
          idletime = sectotime(totalidle * 60 * 60);
        }
      }

      [...Array(7).keys()].map((index) => {
        let date1 = new Date(date);
        date1.setDate(date1.getDate() - index);
        let date2 = date1.toISOString().substring(0, 10);

        let daterec = weekattdata.filter((item, i) => {
          let ssdate = item.date.toISOString().substring(0, 10);
          return ssdate == date2;
        });
        let ssrec = weekata.filter((item, i) => {
          let ssdate = item.date.toISOString().substring(0, 10);
          return ssdate == date2;
        });

        let dayprodtime;
        let dayidletime;
        let dayprodper;
        let dayduration;
        let durationdec = 0;
        if (daterec.length > 0) {
          let daylast_out = daterec[daterec.length - 1].end_time;
         
          if (daylast_out != "00:00:00") {
            // console.log(daylast_out);
            // dayduration = timediff(
            //   date2 + " " + daterec[0].start_time,
            //   date2 + " " + daylast_out
            // );
            // console.log(daterec);
            let totaldec=0;
            if (daterec.length > 0) {
              let diffarr = [];
              daterec.forEach((element1) => {
               let date1 = new Date(
                    moment(element1.date).format("YYYY-MM-DD") +
                    " " +
                    element1.start_time
                );
                let date2 = new Date(
                    moment(element1.date).format("YYYY-MM-DD") + " " + element1.end_time
                );
                let diff;
                if (element1.end_time == "00:00:00") {
                    diff = "00:00:00";
                } else {
                    diff = timediff(date1, date2);
                }
                
                let dec = timetodec(diff);
                let obj = {
                    prodtime: dec,
                };
                diffarr.push(obj);
            });
            // console.log(diffarr);
            totaldec = diffarr.reduce(
                (a, b) => a + Number(b.prodtime),
                0
            );
            // console.log(totaldec);
          }   
          dayduration = dectotime(totaldec *60);
          //  console.log(dayduration); 
          
            let totalidle = 0;
            if (ssrec.length > 0) {
              let diff = ssrec.map((item, i) => {
                return timetodec(item.diff_prev_ss);
              });
              totalidle = diff.reduce((a, b) => a + Number(b), 0);
            }

            if(isNaN(totalidle)==false){
              dayidletime = dectotime(totalidle * 60);
            }else{
              dayidletime = "00:00:00";
            }

            
            dayprodtime = timediff(
              date2 + " " + dayidletime,
              date2 + " " + dayduration
            );

            // durationdec = timetodec(dayduration);
            durationdec = totaldec;
            proddec = timetodec(dayprodtime);
            dayprodper = ((proddec * 100) / durationdec).toFixed(2);
          } else {
            dayduration = "00:00:00";
            dayprodper = "0";
          }
        } else {
          dayprodtime = "00:00:00";
          dayidletime = "00:00:00";
          dayprodper = "0";
          dayduration = "00:00:00";
        }

        let obj = {
          date: date2,
          duration: dayduration,
          durationdec: durationdec,
          prodper: dayprodper,
        };
        weeklyarr.push(obj);
      });
      // console.log(weeklyarr);
      // let date2 = moment(date).format("YYYY-MM-DD");

      let totaldurationdec = await weeklyarr.reduce(
        (a, b) => a + Number(b.durationdec),
        0
      );
      let totalduration = dectotime(totaldurationdec * 60);

      // let weekidletime = sectotime(weekata.length * 120);
      // let weekprodtime = timediff(
      //   date2 + " " + totalduration,
      //   date2 + " " + idletime,
      // );
      let weekproddurdec = totaldurationdec-totalidle;
      // console.log(weekproddurdec);
      let weekprodtime="00:00";
      if(weekproddurdec>0){
        weekprodtime = dectotime(weekproddurdec * 60);
      }
        // console.log(date2);
        // console.log(idletime);
        // console.log(totalduration);
      // let weekdurationdec = timetodec(totalduration);
      // console.log(weekprodtime);
      // let weekproddec = weekprodtime;
      let weekrodper = ((weekproddurdec * 100) / totaldurationdec).toFixed(2);

      weekarr = [
        {
          duration: totalduration,
          prodtime: weekprodtime,
          idletime: idletime,
          prodper: weekrodper >0 ? weekrodper: "00",
        },
      ];
      // console.log(weekarr);
    }
    // console.log(weekarr);
    if (weeklyarr.length > 0) {
      res.status(201).json({
        status: 201,
        summary: arr,
        weeklydata: weeklyarr,
        weeksummary: weekarr,
      });
    } else {
      return res.status(200).json({
        status: "422",
        error: "No data available.",
      });
    }
  } catch (err) {
    console.log(err);
    res.status(500).json({
      error: err,
    });
  }
});

router.post("/get-HourlyProductivity", authenticate, async (req, res) => {
  const { username, date, company_uuid, master } = req.body;
  try {
    let where="";
    // if(master==1){
        where = `and company_uuid='${company_uuid}'`
    // }

    let sql;
    if (!username) {
      sql = `SELECT * FROM attendance_jenyatracking WHERE date='${date}' and is_proj_entry=0 ${where}`;
    } else {
      sql = `SELECT * FROM attendance_jenyatracking WHERE username= '${username}' and is_proj_entry=0  AND date='${date}' ${where}`;
    }
    const [attdata] = await con.execute(sql);
    let arr = [];
    let hourarr = [];
    if (attdata.length > 0) {
      let sql = `SELECT * FROM screenshot WHERE username='${username}'  AND date='${date}' AND clicks=0 AND mouseevent=0 AND keyboardevent=0 AND diff_prev_ss!="" AND diff_prev_ss<="00:03:00" ${where}`;
      const [ssdata] = await con.execute(sql);

      for (let index = 0; index < 23; index++) {
        let filterss = ssdata.filter((item, i) => {
          return item.hours == index;
        });

        let prodtime;
        let idletime;
        let prodper;

        if (filterss.length > 0) {
          idletime = await sectotime(filterss.length * 120);
          prodtime = await timediff(
            date + " " + idletime,
            date + " " + "01:00:00"
          );
          durationdec = await timetodec("01:00:00");
          proddec = await timetodec(prodtime);
          prodper = await ((proddec * 100) / durationdec).toFixed(2);
        } else {
          prodtime = "00:00:00";
          idletime = "00:00:00";
          prodper = "0%";
        }
        if (filterss.length > 0) {
          if (index < 10) index = "0" + index;

          await arr.push(Number(prodper));
          hourarr.push(index + ":00:00");
        }
      }

      if (arr.length > 0) {
        res.status(201).json({
          status: 201,
          data: arr,
          hourarr: hourarr,
        });
      } else {
        return res.status(200).json({
          status: "422",
          error: "No data available.",
        });
      }
    } else {
      return res.status(200).json({
        status: "422",
        error: "No data available.",
      });
    }
  } catch (err) {
    res.status(500).json({
      error: err,
    });
  }
});

router.post("/get-timeline", authenticate, async (req, res) => {
  let { username, date, usertype, department } = req.body;
  date = moment(date).format("YYYY-MM-DD");
  try {
    let sql;
    if (username == "") {
      sql = `select attendance_jenyatracking.*, users.name, users.uuid FROM attendance_jenyatracking LEFT JOIN users on attendance_jenyatracking.username = users.username where attendance_jenyatracking.date='${date}' and attendance_jenyatracking.is_proj_entry=0 and attendance_jenyatracking.company_uuid='${req.body.uuid}' order by id desc`;
    } else {
      sql = `select attendance_jenyatracking.*, users.name, users.uuid FROM attendance_jenyatracking LEFT JOIN users on attendance_jenyatracking.username = users.username where attendance_jenyatracking.username='${username}' and attendance_jenyatracking.date='${date}' and attendance_jenyatracking.is_proj_entry=0 and attendance_jenyatracking.company_uuid='${req.body.uuid}' order by id desc`;
    }
    // console.log(sql);
    let usersql;
    if(usertype==1){
      usersql = `SELECT username,uuid FROM users WHERE active=1 and company_uuid='${req.body.uuid}' and department='${department}'`;
    }else{
      usersql = `SELECT username,uuid FROM users WHERE active=1 and company_uuid='${req.body.uuid}'`;
    }
    let sssql = `SELECT * FROM screenshot WHERE date='${date}'`;
    const [userdata] = await con.execute(usersql);
    const [row] = await con.execute(sql);
    const [ssdata] = await con.execute(sssql);

    let attarr = [];
    if (userdata.length > 0) {
      userdata.forEach((element) => {
        let timearr = [];
        for (let index = 0; index < 24; index++) {
          let time = index;
          if (index < 10) {
            time = "0" + index;
          }

          let timedata = ssdata.filter((item, i) => {
            return item.hours == time && item.username == element.username;
          });

          if (timedata.length > 0) {
            ssarr = [];
            timedata.forEach((sselement, ind) => {
              let color;
              if (
                sselement.clicks == 0 &&
                sselement.mouseevent == 0 &&
                sselement.keyboardevent == 0
              ) {
                color = "#69D5BB";
              } else {
                color = "#1B987A";
              }
              let stime;
              if (ind != 0) {
                stime = timedata[ind - 1].time;
                let obj = {
                  date: date,
                  hours: sselement.hours,
                  starttime: stime,
                  endtime: sselement.time,
                  color: color,
                };
                ssarr.push(obj);
              }
            });
            timearr.push(ssarr);
          } else {
            let obj = {
              date: date,
              hours: time,
              starttime: "",
              endtime: "",
              color: "",
            };
            timearr.push([obj]);
          }
        }

        let timedata = row.filter((item1, i) => {
          return item1.username == element.username;
        });

        if (timedata.length > 0) {
          let date1 = new Date(
            moment(date).format("YYYY-MM-DD") +
              " " +
              timedata[timedata.length - 1].start_time
          );
          let date2 = new Date(
            moment(date).format("YYYY-MM-DD") + " " + timedata[0].end_time
          );
          let diff;
          if (timedata[0].end_time == "00:00:00") {
            diff = "00:00:00";
          } else {
            diff = timediff(date1, date2);
          }

          let data = {
            uuid: timedata[0].uuid,
            name: timedata[0].name,
            date: date,
            in: timedata[timedata.length - 1].start_time,
            out: timedata[0].end_time,
            duration: diff,
            timearr: timearr,
          };
          attarr.push(data);
        }
      });
    }

    if (row.length > 0) {
      res.status(201).json({
        status: 201,
        attdata: attarr,
      });
    } else {
      return res.status(200).json({
        status: "422",
        error: "No data available.",
      });
    }
  } catch (err) {
    res.status(500).json({
      error: err,
    });
  }
});

router.post("/get-monthwise-productivity", authenticate, async (req, res) => {
  let month = req.body.month;
  let year = req.body.year;
  let usertype = req.body.usertype;
  let department = req.body.department;
  let startdate = year + "-" + month + "-01";
  const lastDay = new Date(
    new Date(startdate).getFullYear(),
    new Date(startdate).getMonth() + 1,
    0
  );
  let enddate = moment(lastDay).format("YYYY-MM-DD");

  try {

    // function rtrim1(str, chr) {
    //   var rgxtrim = (!chr) ? new RegExp('\\s+$') : new RegExp(chr+'+$');
    //   return str.replace(rgxtrim, '');
    // }

    // let users = `SELECT username FROM users WHERE active=1 and company_uuid='${req.body.uuid}' and department='${req.body.department}'`;  
    // const [usersdata] = await con.execute(users);
    // console.log(usersdata);
    // let str = "";
    // let usersdataa = usersdata.map(element => {
    //   return str += "'"+element.username +"',"  
    // });
    // rtrim1(",'",str)
    // console.log(usersdataa);

    let sql; 
    let breaksql; 
    let sql2;
    let usersql;
    if(usertype===1){
      sql = `select * FROM attendance_jenyatracking where date >= '${startdate}' and date <= '${enddate}' and company_uuid='${req.body.uuid}' and department='${department}' and end_time!='00:00:00' and is_proj_entry=0`;
      breaksql = `select username,date,start_time,end_time FROM 	attendance_breaks_jenyatracking	 where date >= '${startdate}' and date <= '${enddate}' and company_uuid='${req.body.uuid}' and department='${department}'`;
      usersql = `SELECT uuid,username,name FROM users WHERE active=1 and company_uuid='${req.body.uuid}' and department='${department}'`;  
      sql2 = `SELECT * FROM screenshot WHERE date >='${startdate}' and date <='${enddate}' AND clicks=0 AND mouseevent=0 AND keyboardevent=0 AND diff_prev_ss!="" AND diff_prev_ss<="00:03:00" and company_uuid='${req.body.uuid}' and department='${department}'`;
    }else{
      sql = `select * FROM attendance_jenyatracking where date >= '${startdate}' and date <= '${enddate}' and company_uuid='${req.body.uuid}' and end_time!='00:00:00' and is_proj_entry=0`;
      breaksql = `select username,date,start_time,end_time FROM attendance_breaks_jenyatracking where date >= '${startdate}' and date <= '${enddate}' and company_uuid='${req.body.uuid}' and end_time!='00:00:00'`;
      usersql = `SELECT uuid,username,name FROM users WHERE active=1 and company_uuid='${req.body.uuid}'`;
      sql2 = `SELECT * FROM screenshot WHERE date >='${startdate}' and date <='${enddate}' AND clicks=0 AND mouseevent=0 AND keyboardevent=0 AND diff_prev_ss!="" AND diff_prev_ss<="00:03:00" and company_uuid='${req.body.uuid}'`;
    }
    // console.log(sql);
    const [data] = await con.execute(sql);
    const [userdata] = await con.execute(usersql);    
    const [ssdata] = await con.execute(sql2);
    const [breakdata] = await con.execute(breaksql);
    // console.log(breakdata);
    let totalbreaktime = 0;
    if(breakdata.length>0){
     totalbreaktime = (await breaktimecalculate(breakdata)).breaktimedec;
    }
    // console.log(totalbreaktime);
    let finalarr = [];
    if (userdata.length > 0) {
      for (let index = 0; index < userdata.length; index++) {
        const element = userdata[index];

        let timedata = data.filter((item, i) => {
          return item.username == element.username;
        });

        let idledata = ssdata.filter((item, i) => {
          return item.username == element.username;
        });
      
        let breakdatabyuser = breakdata.filter((item, i) => {
          return item.username == element.username;
        });

        // console.log(breakdatabyuser);

        let totalbreaktime_byuser = 0;
        if(breakdatabyuser.length>0){
          totalbreaktime_byuser =(await breaktimecalculate(breakdatabyuser)).breaktimedec;
        }
        // console.log(totalbreaktime_byuser);

        if (timedata.length > 0) {
          let diffarr = [];
          timedata.forEach((element1) => {
            let date1 =
              moment(element1.date).format("YYYY-MM-DD") +
              " " +
              element1.start_time;
            let date2 =
              moment(element1.date).format("YYYY-MM-DD") +
              " " +
              element1.end_time;

            let diff;
            if (element1.end_time == "00:00:00") {
              diff = "00:00:00";
            } else {
              diff = timediff(date1, date2);
            }
            let dec = timetodec(diff);
            let obj = {
              prodtime: dec,
            };
            diffarr.push(obj);
          });

          let totaldec1 = diffarr.reduce((a, b) => a + Number(b.prodtime), 0);
          let totaldec = totaldec1 - (totalbreaktime_byuser)
          // let idletime = sectotime(idledata.length * 60);
          // console.log(totaldec);
          let totalidle = 0;
          if (idledata.length > 0) {
              let diff = idledata.map((item, i) => {
                  return timetodec(item.diff_prev_ss);
              });
              totalidle = diff.reduce((a, b) => a + Number(b), 0);
          }

          let idletime;
          if(isNaN(totalidle)==false){
              idletime = dectotime(totalidle * 60);
          }else{
              idletime = '00:00:00';
          }

          // let idledec = timetodec(idletime);

          let workingdec = totaldec - totalidle;
          // console.log(workingdec);
          let tottaldur = dectotime(totaldec * 60);

          let workingdur = dectotime(workingdec * 60);

          let prodper = ((workingdec * 100) / totaldec).toFixed(2);

          let obj = {
            uuid: element.uuid,
            employee: element.name,
            working: tottaldur,
            idletime: idletime,
            prod: workingdur,
            prodper: prodper,
          };
          finalarr.push(obj);
        }
      }
    }

    let allarr = [];
    if (data.length > 0) {
      let diffarr = [];
      data.forEach((element1) => {
        let date1 = new Date(
          moment(element1.date).format("YYYY-MM-DD") + " " + element1.start_time
        );
        let date2 = new Date(
          moment(element1.date).format("YYYY-MM-DD") + " " + element1.end_time
        );
        let diff;
        if (element1.end_time == "00:00:00") {
          diff = "00:00:00";
        } else {
          diff = timediff(date1, date2);
        }
        let dec = timetodec(diff);
        let obj = {
          prodtime: dec,
        };
        diffarr.push(obj);
      });
      let totaldec1 = diffarr.reduce((a, b) => a + Number(b.prodtime), 0);
      let totaldec = totaldec1 - (totalbreaktime)
       

      let idledec = 0;
      if (ssdata.length > 0) {
          let diff = ssdata.map((item, i) => {
              return timetodec(item.diff_prev_ss);
          });
          idledec = diff.reduce((a, b) => a + Number(b), 0);
      }
      // console.log(totaldec,idletime); return
      // let idledec = timetodec(idletime);

      let workingdec = totaldec - idledec;
      let prodper = ((workingdec * 100) / totaldec).toFixed(2);
      let idleper = ((idledec * 100) / workingdec).toFixed(2);
      // console.log(totaldec ,workingdec);
      let obj = {
        working: timeconvert(totaldec * 60),
        prodtime: timeconvert(workingdec * 60),

        idletime: timeconvert(idledec * 60),
        idleper: idleper,
        prodper: prodper,
      };

      allarr.push(obj);
    }

    if (finalarr.length > 0) {
      res.status(201).json({
        status: 201,
        data: finalarr,
        allarr: allarr,
      });
    } else {
      return res.status(200).json({
        status: "422",
        error: "No data available.",
      });
    }
  } catch (err) {
    res.status(500).json({
      error: err,
    });
  }
});

module.exports = router;
