const express = require("express");
const router = express.Router();
const con = require("../db/conn").promise();
const moment = require("moment");
const authenticate = require("../middleware/authenticate");
const multer = require("multer");
const fs = require("fs");
const path = require("path");
const { v4: uuidv4 } = require("uuid");

let imagesName;
imagesName = [];
const storage = multer.diskStorage({
  destination: (req, res, callback) => {
    let path = `./uploads/cv`;
    if (!fs.existsSync(path)) {
      fs.mkdirSync(path, {});
    }
    callback(null, path);
  },
  filename: (req, file, callback) => {
    let filename =
      file.fieldname + Date.now() + path.extname(file.originalname);
    callback(null, filename);
    imagesName.push(filename);
  },
});

const upload = multer({
  storage: storage,
});


router.post("/get-birthdaydata", authenticate, async (req, res) => {
  // let month = req.body.month;
  let { month,department, uuid,  usertype} = req.body;

  if (month < 10) {
    month = "0" + month;
  }
  try {
    let sql;
    if(usertype==1){
      sql = `select name, dob FROM users where Month(dob) = '${month}' and active=1 and company_uuid='${uuid}'  and department='${department}'`;
    }else{
      sql = `select name, dob FROM users where Month(dob) = '${month}' and active=1 and company_uuid='${uuid}'`;
    }

    const [data] = await con.execute(sql);
    let finalarr = [];
    data.forEach(element => {
      let dob = moment(element.dob).format("YYYY-MM-DD");
      let obj = {
        name:element.name,
        dob:dob,
      }
      finalarr.push(obj)
    });
    


    if (finalarr.length > 0) {
      res.status(201).json({
        status: 201,
        data: finalarr,
      });
    } else {
      return res.status(200).json({
        status: "422",
        error: "No data available.",
      });
    }
  } catch (err) {
    res.status(500).json({
      error: err,
    });
  }
});

router.post("/get-Holidaydata", authenticate, async (req, res) => {
  let month = req.body.month;
  let year = req.body.year;
  if (month < 10) {
    month = "0" + month;
  }

  try {
    let sql = `select name, date FROM holidays where Month(date) = '${month}' and Year(date) = '${year}' and uuid='${req.body.uuid}' `;

    const [data] = await con.execute(sql);

    if (data.length > 0) {
      res.status(201).json({
        status: 201,
        data: data,
      });
    } else {
      return res.status(200).json({
        status: "422",
        error: "No data available.",
      });
    }
  } catch (err) {
    res.status(500).json({
      error: err,
    });
  }
});


router.post("/getAllProjhrs", authenticate, async (req, res) => {
  // let month = req.body.month;
  // let year = req.body.year;
  // if (month < 10) {
  //   month = "0" + month;
  // }

  try {
    // let sql = `select * FROM project_hrs`;
    let sql = `SELECT
                project_hrs.*,
                projects.name  as projname,
                project_activity.activity_name
              FROM project_hrs
             LEFT JOIN projects
                ON projects.project_id = project_hrs.proj_id
             LEFT JOIN project_activity
                ON project_activity.activity_id = project_hrs.act_id order by project_hrs.id desc`;

    const [data] = await con.execute(sql);
    
    let projsql = `select project_id as value, name as label from projects where department=6 and status=1`;

    const [projects] = await con.execute(projsql);

    if (data.length > 0 || projects.length > 0) {
      res.status(201).json({
        status: 201,
        data,
        projects,
      });
    } else {
      return res.status(200).json({
        status: "422",
        error: "No data available.",
      });
    }
  } catch (err) {
    res.status(500).json({
      error: err,
    });
  }
});


router.post("/get-project-activity", authenticate, async (req, res) => {
  let proj = req.body.proj;
  // console.log(proj); return
  try {
    let sql = `select activity_id as value, activity_name as label,billable,status,created_at FROM project_activity where project_id=${proj} order by value desc`;  
    // console.log(sql); return
    const [data] = await con.execute(sql);  
  
    if (data.length > 0) {
      res.status(201).json({
        status: 201,
        data,
      });
    } else {
      return res.status(200).json({
        status: "422",
        error: "No data available.",
      });
    }
  } catch (err) {
    res.status(500).json({
      error: err,
    });
  }
});


router.post('/get-attendancedata', authenticate, async (req, res) => {
  let { date, department, uuid, usertype} = req.body;

  try{  
        var sql;
        var sql1;
        var sql2;
        if(usertype==1){
            sql = `select attendance_jenyatracking.*, users.name,users.user_id FROM attendance_jenyatracking LEFT JOIN users on attendance_jenyatracking.username = users.username where attendance_jenyatracking.date = '${date}' and attendance_jenyatracking.company_uuid='${uuid}' and attendance_jenyatracking.is_proj_entry=0 and  attendance_jenyatracking.department='${department}' group by attendance_jenyatracking.username `;        
            sql1 = `select leave_requests_new.*,users.name, users.user_id FROM leave_requests_new left join users on leave_requests_new.user_id=users.user_id where leave_requests_new.start_date = '${date}' and leave_requests_new.company_uuid='${uuid}' and users.department='${department}'`;
            sql2 = `select * FROM users where active = 1 and company_uuid='${req.body.uuid}' and department='${department}'`;
        }else{
            sql = `select attendance_jenyatracking.*, users.name,users.user_id FROM attendance_jenyatracking LEFT JOIN users on attendance_jenyatracking.username = users.username where attendance_jenyatracking.date = '${date}' and attendance_jenyatracking.is_proj_entry=0 and attendance_jenyatracking.company_uuid='${uuid}' group by attendance_jenyatracking.username`;        
            sql1 = `select leave_requests_new.*,users.name, users.user_id FROM leave_requests_new left join users on leave_requests_new.user_id=users.user_id where leave_requests_new.start_date = '${date}' and leave_requests_new.company_uuid='${uuid}'`;
            sql2 = `select * FROM users where active = 1 and company_uuid='${req.body.uuid}'`;
        }    
        const [data] = await con.execute(sql);          
        const [leavedata] = await con.execute(sql1);
        const [userdata] = await con.execute(sql2); 

        let punchedusers = data.map((item,i)=> item.name);
       
          if(userdata.length > 0){
              let presentdata = data.filter((item,i)=>{
                  return item.start_time!=='00:00:00'
              });

              let absentdata = [];
              userdata.forEach(element => {
                 let fildata = data.filter((item,i)=> item.username==element.username);                    
                 if(fildata.length==0){
                  absentdata.push(element.name)
                 }
              });

              let onleaveusers = leavedata.map(item=>item.name);

              // var arr1 = userdata.filter(function(item){
              //     return data.indexOf(item.user_id) === -1;
              //   });
              // let absentdata = arr1.map(item=>item.name);

          //    console.log(absentdata);
              let present = presentdata.length>0 ? presentdata.length :0;
              // console.log(present)
              
              // var onleavesql = `select noofdays FROM leave_requests_new where start_date='${date}'`;
              // const [onleavedata] = await con.execute(onleavesql);
             
              let onleave = 0;
              leavedata.forEach(element => {
                  onleave = onleave + Number(element.noofdays);
              });

              let totalmembers = userdata.length>0 ? userdata.length :0;
              let absent = totalmembers-present;
              absent = absent-onleave
              //console.log(absent)

              let arr = [{
                  totalmembers,
                  present,
                  presentper: ((present/totalmembers) * 100).toFixed(0),
                  onleave,
                  onleaveper: ((onleave/totalmembers) * 100).toFixed(0),
                  absent:absent,
                  absentper: ((absent/totalmembers) * 100).toFixed(0),
                  presentusers:punchedusers,
                  absentusers:absentdata,
                  onleaveusers:onleaveusers,
              }]
              res.status(201).json({status:201,arr});
          }else{
              return res.status(200).json({status: "422",error:"No data available."});
          }        
  }catch(err){
      res.status(500).json({error:err});
  }
});


// router.post("/get-attendancedata", authenticate, async (req, res) => {
//   let date = req.body.date;
  

//   try {
//     let sql1 = `select * FROM users where active = 1 and company_uuid='${req.body.uuid}'`;
//     const [userdata] = await con.execute(sql1);
//     // console.log(sql1);
//     // let data=[]

//     // for (let i = 0; i < userdata.length; i++) {
//     //   const element = userdata[i];
//     //   let sql = `select * FROM attendance_jenyatracking where date ='${date}' and username=${element.username}`;
//     //   let sql = `select * FROM attendance_jenyatracking where date ='${date}' and company_uuid='${req.body.uuid}'`;
//     //   console.log(sql);
//     //   const data = await con.execute(sql);  
//     // data.push(data)
//     // }

//     let sql = `select * FROM attendance_jenyatracking where date ='${date}' and company_uuid='${req.body.uuid}'`;
//     const data = await con.execute(sql);  

//     // console.log(data[0]);

    
    

    

//     if (userdata.length > 0) {
//       let presentdata = data[0].filter((item, i) => {
//         return item.start_time !== "00:00:00" ;
//       });
//       // console.log(presentdata);
//       let present = presentdata.length > 0 ? presentdata.length : 0;

//       let onleavesql = `select noofdays FROM leave_requests_new where start_date='${date}'`;
//       const [onleavedata] = await con.execute(onleavesql);

//       let onleave = 0;
//       onleavedata.forEach((element) => {
//         onleave = onleave + Number(element.noofdays);
//       });

//       let totalmembers = userdata.length > 0 ? userdata.length : 0;
//       let absent = totalmembers - present;

//       let arr = [
//         {
//           totalmembers,
//           present,
//           onleave,
//           absent,
//         },
//       ];
//       res.status(201).json({
//         status: 201,
//         arr,
//       });
//     } else {
//       return res.status(200).json({
//         status: "422",
//         error: "No data available.",
//       });
//     }
//   } catch (err) {
//     // console.log(err);
//     res.status(500).json({
//       error: err,
//     });
//   }
// });

router.post("/get-proddata", authenticate, async (req, res) => {
  let month = req.body.month;
  let year = req.body.year;
  let type = req.body.type;
  if (month < 10) {
    month = "0" + month;
  }
  let startdate = year + "-" + month + "-01";
  const lastDay = new Date(
    new Date(startdate).getFullYear(),
    new Date(startdate).getMonth() + 1,
    0
  );
  let enddate = moment(lastDay).format("YYYY-MM-DD");

  try {
    let sql = `select * FROM attendance_jenyatracking where date >= '${startdate}' and date <= '${enddate}' and is_proj_entry=0`;
    const [data] = await con.execute(sql);

    if (data.length > 0) {
      res.status(201).json({
        status: 201,
        data: data,
      });
    } else {
      return res.status(200).json({
        status: "422",
        error: "No data available.",
      });
    }
  } catch (err) {
    res.status(500).json({
      error: err,
    });
  }
});

// Ticket

router.post("/create-ticket", authenticate, async (req, res) => {
  let { id, start_time, end_time,date, description } = req.body.data;
  let { punchtype, company_uuid, user_uuid, tickettype } = req.body;

  try {
    let msg;
    let sql = `select * FROM attendance_tickets where attendance_id = '${id}'`;
    const [data] = await con.execute(sql);

    if (data.length > 0) {
      sql = `update attendance_tickets set punch_type='${punchtype}', start_time='${start_time}', end_time='${end_time}', status='0', message='${description}' where attendance_id = '${id}'`;
      msg = "Update";
    } else {
      let created_at = moment(new Date()).format("YYYY-MM-DD HH:mm:00");
      sql = `INSERT INTO attendance_tickets (company_uuid, user_uuid, attendance_id, punch_type, date, start_time, end_time,  message,status, ticket_type, created_at) VALUES ('${company_uuid}', '${user_uuid}','${id}','${punchtype}','${date}', '${start_time}', '${end_time}','${description}',0,'${tickettype}','${created_at}')`;
      msg = "Insert";
    }
    const [data1] = await con.execute(sql);
    if (data1) {
      res.status(201).json({
        status: 201,
        message: msg + " success",
      });
    } else {
      return res.status(200).json({
        status: "422",
        error: "Failed to Process",
      });
    }
  } catch (err) {
    console.log(err);
    res.status(500).json({
      error: err,
    });
  }
});

router.post("/getTickets", authenticate, async (req, res) => {
  let { uuid } = req.body;
   try {
    let msg;
    // let sql = `select * FROM attendance_tickets where company_uuid = '${uuid}' order by id desc limit 100`;
    let sql = `SELECT
        attendance_tickets.*,
        users.name  as user
        FROM attendance_tickets
        LEFT JOIN users
        ON users.uuid = attendance_tickets.user_uuid
        where attendance_tickets.company_uuid = '${uuid}' order by attendance_tickets.id desc limit 100`;
    // console.log(sql);
        
    const [data] = await con.execute(sql);
    if (data) {
      res.status(201).json({
        status: 201,
        data
      });
    } else {
      return res.status(200).json({
        status: "422",
        error: "Failed to get data",
      });
    }
  } catch (err) {
    res.status(500).json({
      error: err,
    });
  }
});

router.post("/ticket-status-change", authenticate, async (req, res) => {
  let { id,status,tickettype } = req.body;
  // console.log(id,status); return
   try {
    if(status==1){
      let ticketsql = `select * FROM attendance_tickets where id = '${id}'`;
      const [ticketdata] = await con.execute(ticketsql);

      let usersql = `select username FROM users where uuid = '${ticketdata[0]['user_uuid']}'`;
      const [userdata] = await con.execute(usersql);
      // console.log(ticketdata); return
      let time="";
      let uptime="";
      let atttime="";
      let date_ticket = moment(new Date(ticketdata[0].date)).format("YYYY-MM-DD");
      if(ticketdata[0]['punch_type']==0){
        time="start_time";
        if(tickettype==1){
          atttime="lunch_in_time";
        }else{
          atttime="job_in_time";
        }
        uptime=ticketdata[0]['start_time'];
      }else{
        time="end_time";
        if(tickettype==1){
          atttime="lunch_out_time";;
        }else{
          atttime="job_out_time";
        }        
        uptime=ticketdata[0]['end_time'];
      }
      let table = "attendance_jenyatracking";
      if(tickettype==1){
        table = "	attendance_breaks_jenyatracking	";
      }
      
      
      updatesql = `update ${table} set ${time}='${uptime}' where id='${ticketdata[0]['attendance_id']}'`;
      await con.execute(updatesql);
      attsql = `update attendance set ${atttime}='${uptime}' where user_id='${userdata[0]['username']}' and date = '${date_ticket}'`;        
      
      updatesql = `select * from ${table} where id='${id}'`;
      let fdata = await con.execute(updatesql);
      if(tickettype==0){
        await con.execute(attsql);
      }else if(tickettype==1 && fdata && fdata[0]['islunch']==1){
        await con.execute(attsql);
      }
    }
    sql = `update attendance_tickets set status='${status}' where id = '${id}'`;
    const [data] = await con.execute(sql);
    if (data) {
      res.status(201).json({
        status: 201,
        message: "success",
      });
    } else {
      return res.status(200).json({
        status: "422",
        error: "Failed to get data",
      });
    }
  } catch (err) {
    console.log(err);
    res.status(500).json({
      error: err,
    });
  }
});

// Job Application

router.post("/job-application", upload.array("cv"), async (req, res) => {
  // console.log(req.body); 
  let { fullname, email, contactno, city,address, position,noticeperiod,is_from_othersite=0,cvname="",knowvavancy } = JSON.parse(req.body.data);
  let imagename ="";
  if (imagesName[0] != undefined) {
    imagename = imagesName[imagesName.length-1];
  }
  try {   
    let uuid = uuidv4();
    let created_at = moment(new Date()).format("YYYY-MM-DD HH:mm:ss");
    sql = `INSERT INTO applications (uuid, name, profilepic, applicationdate, address, city, email, contactno, position,  noticeperiod,datetime,resume, is_from_othersite,cvname,knowvavancy) VALUES ('${uuid}','${fullname}', '${req.body.picture}', '${created_at}','${address}','${city}','${email}', '${contactno}', '${position}','${noticeperiod}','${created_at}','${imagename}','${is_from_othersite}','${cvname}','${knowvavancy}')`;
    // console.log(sql);
    const [data1] = await con.execute(sql);
    if (data1) {
      res.status(201).json({
        status: 201,
        uuid,
        message:"Form submitted successfully, We will get back to you soon!"
      });
    } else {
      return res.status(200).json({
        status: "422"       
      });
    }
  } catch (err) {
    // console.log(err);
    res.status(500).json({
      error: err,
    });
  }
});



// Job Application SAVE

router.post("/job-application-save", async (req, res) => {
  // console.log(JSON.parse(req.body)); return
  let { uuid, currentsalary,salaryexp,totalworkexp_years,totalworkexp_months, istraining, fromwheretraining, isrelocate, skill, education,address,dob} = req.body.data;

  // console.log(currentsalary);
  // let { uuid } = req.body.uuid;
  // console.log(uuid, currentsalary,salaryexp,totalworkexp_years,totalworkexp_months, istraining, fromwheretraining, isrelocate); return
  
  try {   
    let form_submitted_at = moment(new Date()).format("YYYY-MM-DD HH:mm:ss");
    let dob_con = moment(new Date(dob)).format("YYYY-MM-DD");
    let exp = totalworkexp_years+' Years '+totalworkexp_months+' months';
  
    sql = `update applications set yourskills='${skill}', dob='${dob_con}', education='${education}', address='${address}', currentsalary='${currentsalary}', expectedsalary='${salaryexp}', totalworkexperience='${exp}', istraining='${istraining}', fromwheretraining='${fromwheretraining}', form_submitted_at='${form_submitted_at}', status='1', isrelocate='${isrelocate}' where uuid = '${uuid}'`;
    // console.log(sql); return
    const [data1] = await con.execute(sql);
    if (data1) {
      res.status(201).json({
        status: 201,
        uuid,
        message:"Form submitted successfully, We will get back to you soon!"
      });
    } else {
      return res.status(200).json({
        status: "422"       
      });
    }
  } catch (err) {
    // console.log(err);
    res.status(500).json({
      error: err,
    });
  }
});



// security entry

router.post("/security-entry", async (req, res) => {
  // console.log(req.body.data); return
  let { name, email, phone, reason, to_whom_wantto_meet } = JSON.parse(req.body.data);
  try {   
    let created_at = moment(new Date()).format("YYYY-MM-DD HH:mm:ss");
    sql = `INSERT INTO security_entry (name, email, photo, phone, reason, to_whom_wantto_meet, created_at) VALUES ('${name}','${email}', '${req.body.picture}', '${phone}','${reason}','${to_whom_wantto_meet}', '${created_at}')`;
    const [data1] = await con.execute(sql);
    if (data1) {
      res.status(201).json({
        status: 201,
      });
    } else {
      return res.status(200).json({
        status: "422",
      });
    }
  } catch (err) {
    console.log(err);
    res.status(500).json({
      error: err,
    });
  }
});


router.post("/getAllJobApp", authenticate, async (req, res) => {
  const momenttz = require('moment-timezone');
  let { uuid,date,username,position,type,InterviewStatus } = req.body;
  // console.log(date0);
   try {
    let msg;
    let sdate = moment(new Date(date[0])).format("YYYY-MM-DD 00:00:00");
    let ldate = moment(new Date(date[1])).format("YYYY-MM-DD 23:59:59");
    
    let sql;
    if(position==""){
      sql = `select * FROM applications where applicationdate between '${sdate}' and '${ldate}' and interviewStatus='${InterviewStatus}'  order by application_id desc`;
    }else{
      sql = `select * FROM applications where applicationdate between '${sdate}' and '${ldate}'  and interviewStatus='${InterviewStatus}' and position='${position}' order by application_id desc`;
    }
    // console.log(sql);
    const [data] = await con.execute(sql);
    if (data) {
      let arr = [];
      for (let index = 0; index < data.length; index++) {
        const item = data[index];
        let time = momenttz.utc(item.applicationdate, 'YYYY-MM-DD HH:mm:ss').tz("Asia/kolkata").format('YYYY-MM-DD HH:mm:ss');
        // let obj = item
        // console.log(item);
        let sql1 = `select * FROM job_assessment where application_id='${item.uuid}'`;
        const [assdata] = await con.execute(sql1);
        if(assdata.length>0){
          item.isassessmentadded = 1;
        }else{
          item.isassessmentadded = 0;
        }
        item.applicationdate = time
        let sql = `select * FROM positions where uuid='${item.position}'`;
        const [positiondata] = await con.execute(sql);
        if(positiondata.length>0){
          item.position = positiondata[0].name
        }else{
          item.position = ""
        }
        arr.push(item)
      }
      res.status(201).json({
        status: 201,
        data:arr
      });
    } else {
      return res.status(200).json({
        status: "422",
        error: "Failed to get data",
      });
    }
  } catch (err) {
    console.log(err);
    res.status(500).json({
      error: err,
    });
  }
});


router.post("/getAllSecurityData", authenticate, async (req, res) => {
  const momenttz = require('moment-timezone');
  let { uuid } = req.body;
   try {
    let msg;
    let sql = `select * FROM security_entry order by id desc`;
    const [data] = await con.execute(sql);
    if (data) {
      let arr = [];     
      for (let index = 0; index < data.length; index++) {
        const item = data[index];
        let time = momenttz.utc(item.created_at, 'YYYY-MM-DD HH:mm:ss').tz("Asia/kolkata").format('YYYY-MM-DD HH:mm:ss');
        item.created_at = time
        arr.push(item)
      }
      res.status(201).json({
        status: 201,
        data:arr
      });
    } else {
      return res.status(200).json({
        status: "422",
        error: "Failed to get data",
      });
    }
  } catch (err) {
    res.status(500).json({
      error: err,
    });
  }
});


router.delete("/delete-ticket/:id", authenticate, async (req, res) => {
  let { id } = req.params;
  try {
    let sql = `delete FROM attendance_tickets where attendance_id=${id}`;
    // console.log(sql);
    const [row] = await con.execute(sql);
    if (row) {
      res.status(201).json({
        status: 201,
        msg: "Record deleted successfully",
      });
    } else {
      return res.status(200).json({
        status: "422",
        msg: "Failed to delete.",
      });
    }
  } catch (err) {
    res.status(500).json({
      error: err,
    });
  }
})

module.exports = router;

