const express = require("express");
const router = express.Router();
const con = require("../db/conn").promise();

const {
    breaktimecalculate,
    timediff,
    sectotime,
    timetodec,
    dectotime,
    calavg,
} = require("../services/Time");
const moment = require("moment");
const authenticate = require("../middleware/authenticate");

router.post("/get-chartdata", authenticate, async (req, res) => {
    let month = req.body.month;
    let usertype = req.body.usertype;
    let department = req.body.department;
    let year = req.body.year;
    if (month < 10) {
        month = month;
    }
    let startdate = year + "-" + month + "-01";
    const lastDay = new Date(
        new Date(startdate).getFullYear(),
        new Date(startdate).getMonth() + 1,
        0
    );
    let enddate = moment(lastDay).format("YYYY-MM-DD");

    try {
        let sql1;
        let sql2;
        let breaksql; 
        if(usertype===1){
            sql1 = `select * FROM attendance_jenyatracking where  date >= '${startdate}' and date <= '${enddate}' and company_uuid='${req.body.uuid}' and department='${department}' and end_time!='00:00:00' and is_proj_entry=0`;
            sql2 = `select date,count(*) as totalpresent FROM attendance_jenyatracking where punching_times=1 and date >= '${startdate}' and date <= '${enddate}' and department='${department}' and company_uuid='${req.body.uuid}'  and is_proj_entry=0 group by date`;
            breaksql = `select date,start_time,end_time FROM 	attendance_breaks_jenyatracking	 where date >= '${startdate}' and date <= '${enddate}' and company_uuid='${req.body.uuid}' and department='${department}'`;
        }else{
            sql1 = `select * FROM attendance_jenyatracking where  date >= '${startdate}' and date <= '${enddate}' and company_uuid='${req.body.uuid}' and end_time!='00:00:00' and is_proj_entry=0`;
            sql2 = `select date,count(*) as totalpresent FROM attendance_jenyatracking where punching_times=1 and date >= '${startdate}' and date <= '${enddate}' and company_uuid='${req.body.uuid}'  and is_proj_entry=0 group by date`;
            breaksql = `select date,start_time,end_time FROM attendance_breaks_jenyatracking where date >= '${startdate}' and date <= '${enddate}' and company_uuid='${req.body.uuid}' and end_time!='00:00:00'`;
        }
        let [attdata] = await con.execute(sql1);  
        let [attdata1] = await con.execute(sql2);  
        const [breakdata] = await con.execute(breaksql);

       
        // if(breakdata.length>0){
        //  totalbreaktime = await breaktimecalculate(breakdata);
        // }

        // console.log(totalbreaktime);
    
        
        let datearr = [];
        let presentarr = [];
        if (attdata.length > 0) {
            let start = new Date(startdate);
            let end = new Date(enddate);
            let loop = new Date(start);
            let allarr = [];
            
            while (loop <= end) {
                let date = moment(loop).format("YYYY-MM-DD");

                let allpre = attdata.filter((item) => {
                    return date == moment(item.date).format("YYYY-MM-DD");
                });
                let breakdatabydate = breakdata.filter((item) => {
                    return date == moment(item.date).format("YYYY-MM-DD");
                });
               
               
                let totalbreaktime = 0;
                if(breakdatabydate.length>0){
                    totalbreaktime = (await breaktimecalculate(breakdatabydate)).breaktimedec;
                }
                // console.log(totalbreaktime); return
               
                let allidless = attdata.filter((item) => {
                    return (
                        date == moment(item.date).format("YYYY-MM-DD") &&
                        item.clicks == 0 &&
                        item.mouseevent == 0 &&
                        item.keyboardevent == 0 &&
                        diff_prev_ss!=""
                    );
                });
                let diffarr = [];
                // let prearr = [];
                console.log(allpre);
                allpre.forEach(async (element1) => {
                  
                    let date1 = new Date(
                        moment(element1.date).format("YYYY-MM-DD") +
                        " " +
                        element1.start_time
                    );

                    let date2 = new Date(
                        moment(element1.date).format("YYYY-MM-DD") + " " + element1.end_time
                    );

                    // console.log(attdata); return
                      
                    let diff;
                    if (element1.end_time == "00:00:00") {
                        diff = "00:00:00";
                    } else {
                        diff = timediff(date1, date2);
                    }
                    let dec = timetodec(diff);
                    let obj = {
                        prodtime: dec,
                    };
                    diffarr.push(obj);
                });

                // console.log(prearr);

                let totaldec = await diffarr.reduce(
                    (a, b) => a + Number(b.prodtime),0
                );

                let totalidle = 0;
                if (allidless.length > 0) {
                  let diff = allidless.map((item, i) => {
                    return timetodec(item.diff_prev_ss);
                  });
                  totalidle = diff.reduce((a, b) => a + Number(b), 0);
                }

                let idletime = dectotime(totalidle * 60);
                let idledec = timetodec(idletime);

                let workingdec1 = totaldec - idledec;
                let workingdec = workingdec1-(totalbreaktime);

                // console.log(workingdec1,totalbreaktime);

                // console.log(workingdec1,totalbreaktime.breaktimedec);
                // console.log(totalbreaktime);

                allarr.push(workingdec.toFixed(2));

                datearr.push(date);
               
                let allpre1 = attdata1.filter((item) => {
                    return date == moment(item.date).format("YYYY-MM-DD");
                });
                // presentarr.push
                // console.log(allpre1[0].totalpresent);
                if(allpre1.length>0){
                    presentarr.push(allpre1[0].totalpresent)
                }else{
                    presentarr.push(0)
                }
                let newDate = loop.setDate(loop.getDate() + 1);
                loop = new Date(newDate);
            }

            // let totalpresent = attdata1.reduce((a, b) => a + Number(b.totalpresent), 0);
            // console.log(attdata1);
            // presentarr.push(presentarr);

            // console.log(presentarr);

            let presentdata = [{
                dates: datearr,
                value: presentarr,
            }, ];
            let hrsdata = [{
                dates: datearr,
                value: allarr,
            }, ];

            res.status(201).json({
                status: 201,
                attdata: presentdata,
                hrsdata: hrsdata,
            });
        } else {
            return res.status(200).json({
                status: "422",
                error: "No data available.",
            });
        }
    } catch (err) {
        console.log(err);
        res.status(500).json({
            error: err,
        });
    }
});

router.post("/get-datewise-productivity", authenticate, async (req, res) => {
    const {
        usertype,
        department,
        username,
        date,
        ldate,company_uuid,master
    } = req.body;

    try {
        let sql;
        let idlesql;
        let usersql;
        let breaksql;
        let where="";
        if(usertype==1){
            where = `and department='${department}' and company_uuid='${company_uuid}'`;
        }else{
            where = `and company_uuid='${company_uuid}'`;
        }
        if (username != "") {
            idlesql = `SELECT * FROM screenshot WHERE date>='${date}' and date<='${ldate}' AND clicks=0 AND mouseevent=0 AND keyboardevent=0 AND diff_prev_ss!="" AND diff_prev_ss<="00:03:00" and username='${username}' ${where}`;
            sql = `select * FROM attendance_jenyatracking where date >='${date}' and date <= '${ldate}' and username='${username}' ${where} and end_time!='00:00:00'  and is_proj_entry=0`;
            usersql = `SELECT uuid,username,name FROM users WHERE active=1 and username='${username}' ${where}`;
            
            breaksql = `select date,start_time,end_time FROM attendance_breaks_jenyatracking where date >= '${date}' and date <= '${ldate}' and username='${username}'  and end_time!='00:00:00' ${where}`;

        } else {
            sql = `select * FROM attendance_jenyatracking where date >='${date}' and date <= '${ldate}'  ${where}  and end_time!='00:00:00'  and is_proj_entry=0`;
            idlesql = `SELECT * FROM screenshot WHERE date>='${date}' and date<='${ldate}' AND clicks=0 AND mouseevent=0 AND keyboardevent=0 AND diff_prev_ss!="" AND diff_prev_ss<="00:03:00" ${where}`;
            usersql = `SELECT uuid,username,name FROM users WHERE active=1 ${where}`;
            breaksql = `select date,start_time,end_time FROM attendance_breaks_jenyatracking where date >= '${date}' and date <= '${ldate}'  and end_time!='00:00:00' ${where}`;
        }
        // console.log(idlesql);
        const [userdata] = await con.execute(usersql);

        const [data] = await con.execute(sql);
        const [ssdata] = await con.execute(idlesql);
        const [breakdata] = await con.execute(breaksql);
        // console.log(ssdata);
        // console.log('idledata'); return

        let totalbreaktime = 0;
        if(breakdata.length>0){
         totalbreaktime = await breaktimecalculate(breakdata);
        }

        let finalarr = [];
        let start = new Date(date);
        let end = new Date(ldate);
        let loop = new Date(start);
        let totalworking = [];
        let totalprod = [];
        let totalidledata = [];
        let datearr = [];
        while (loop <= end) {
            let date = moment(loop).format("YYYY-MM-DD");
            datearr.push(date);

            let timedata = data.filter((item, i) => {
                return moment(item.date).format("YYYY-MM-DD") == date;
            });

            let idledata = ssdata.filter((item, i) => {
                return moment(item.date).format("YYYY-MM-DD") == date;
            });

            let breakdatabyuser = breakdata.filter((item, i) => {
                return moment(item.date).format("YYYY-MM-DD") == date;
              });

            let totalbreaktime_byuser = 0;
            if(breakdatabyuser.length>0){
            totalbreaktime_byuser =(await breaktimecalculate(breakdatabyuser)).breaktimedec;
            }
            // console.log(totalbreaktime_byuser);
            let totalidle = 0;
            
            //  return
            if (idledata.length > 0) {
                let diff = idledata.map((item, i) => {
                    return timetodec(item.diff_prev_ss);
                });
                // console.log(diff);
                totalidle = diff.reduce((a, b) => a + Number(b), 0);
            }
          
            totalidledata.push(totalidle);
            if (timedata.length > 0) {
                let diffarr = [];
                timedata.forEach((element1) => {
                    let date1 = new Date(
                        moment(element1.date).format("YYYY-MM-DD") +
                        " " +
                        element1.start_time
                    );
                    let date2 = new Date(
                        moment(element1.date).format("YYYY-MM-DD") + " " + element1.end_time
                    );
                    let diff;
                    if (element1.end_time == "00:00:00") {
                        diff = "00:00:00";
                    } else {
                        diff = timediff(date1, date2);
                    }
                    let dec = timetodec(diff);
                    let obj = {
                        prodtime: dec,
                    };
                    diffarr.push(obj);
                });
                let totaldec = await diffarr.reduce(
                    (a, b) => a + Number(b.prodtime),
                    0
                );
                totalworking.push(totaldec);
                // console.log(totalidle);
                let idletime;
                if(isNaN(totalidle)==false){
                    idletime = sectotime(totalidle * 60 * 60);
                }else{
                    idletime = "00:00:00";
                }

                let workingdec1 = totaldec - totalidle;
                let workingdec = workingdec1-totalbreaktime_byuser;
                let tottaldur
                if(workingdec>0){
                    tottaldur = dectotime(totaldec * 60);
                }else{
                    tottaldur="00:00:00";
                }
                totalprod.push(workingdec);

                let workingdur = dectotime(workingdec * 60);
                let prodper = ((workingdec * 100) / totaldec).toFixed(2);

                let obj = {
                    date: date,
                    working: tottaldur,
                    idletime: idletime,
                    prod: workingdur,
                    prodper: prodper,
                };
                finalarr.push(obj);
            } else {
                totalworking.push(0);
            }

            let newDate = loop.setDate(loop.getDate() + 1);
            loop = new Date(newDate);
        }

        // console.log(totalbreaktime);
        let totalworkingdec = totalworking.reduce((a, b) => a + b, 0)-totalbreaktime.breaktimedec;
        let totalproddec = totalprod.reduce((a, b) => a + b, 0);
        let totalidledec = totalidledata.reduce((a, b) => a + b, 0);
        // console.log(totalidledata);
        let avgtotalworking = calavg(totalworking);
        let avgtotalidle = calavg(totalidledata);
        let avgtotalprod = calavg(totalprod);
        // console.log(totalproddec);
        let actobj = {
            totalworking: totalworkingdec>0 ? dectotime(totalworkingdec * 60) : '00:00:00',
            totalidle: isNaN(totalidledec)==false ? dectotime(totalidledec * 60) : '00:00:00',
            totalprod: totalproddec>0 ? dectotime(totalproddec * 60) : '00:00:00',
            avgtotalworking: avgtotalworking>0 ? dectotime(avgtotalworking * 60) : '00:00:00',
            avgtotalidle: avgtotalidle>0 ? dectotime(avgtotalidle * 60) : '00:00:00',
            avgtotalprod: avgtotalprod>0 ? dectotime(avgtotalprod * 60) : '00:00:00',
        };

        let idlearr = [];
        if (userdata.length > 0) {
            userdata.forEach((element) => {
                let idledata = ssdata.filter((item, i) => {
                    return item.username == element.username;
                });

                if (idledata.length > 0) {
                    let totalidle = 0;
                    if (idledata.length > 0) {
                        let diff = idledata.map((item, i) => {
                            return timetodec(item.diff_prev_ss);
                        });
                        totalidle = diff.reduce((a, b) => a + Number(b), 0);
                    }

                    let idletime;
                    if(isNaN(totalidle)==false){
                        idletime = dectotime(totalidle * 60);
                    }else{
                        idletime = '00:00:00';
                    }

                    let obj = {
                        uuid: element.uuid,
                        employee: element.name,
                        idletime: idletime,
                        idledec: totalidle,
                    };
                    // console.log(obj);
                    idlearr.push(obj);
                }
            });
        }

        let finalidle = idlearr.sort((a, b) => (a.idledec < b.idledec ? 1 : -1));

        let totalworkingarr = {
            dates: datearr,
            value: totalworking.map((item) => item.toFixed(2)),
        };
        let totalidlearr = {
            dates: datearr,
            value: totalidledata.map((item) => item.toFixed(2)),
        };
        let totalprodarr = {
            dates: datearr,
            value: totalprod.map((item) => item.toFixed(2)),
        };

        if (data.length > 0) {
            res.status(201).json({
                status: 201,
                data: finalarr,
                idlearr: finalidle,
                actinfo: actobj,
                totalworkingchart: [totalworkingarr],
                totalidlechart: [totalidlearr],
                totalprodchart: [totalprodarr],
            });
        } else {
            return res.status(200).json({
                status: "422",
                error: "No data available.",
            });
        }
    } catch (err) {
        // console.log(err);
        res.status(500).json({
            error: err,
        });
    }
});

module.exports = router;