// const { createHmac } = require("node:crypto");
const secret = "";
const express = require("express");
const router = express.Router();
const con = require("../db/conn").promise();
const jwt = require("jsonwebtoken");
const cors = require("cors");
const app = express();
const moment = require("moment");
const path = require("path");
const authenticate = require("../middleware/authenticate");
const { timediff, timetodec, dectotime } = require("../services/Time");
const multer = require("multer");
const fs = require("fs");
const { generateOTP } = require("../services/OTP");
const { v4: uuidv4 } = require("uuid");
const chech = require("../middleware/chech_sub");
const { log } = require("node:console");
const { createHash } = require('crypto');
app.use(express.urlencoded({ extended: true }));
app.use(cors());


router.post("/client-signin", async (req, res) => {
    try {
      const { type, user_id, password } = req.body;
      if (!user_id || !password) {
        return res.status(200).json({
          error: "Please Enter Value",
        });
      }
  
      const [row] = await con.execute(
        "SELECT * FROM clients where `email`=? and `password`=?",
        [user_id,createHash('sha256').update(password).digest('hex')]
    );
        // console.log(user_id,createHash('sha256').update(password).digest('hex')); return
    if (row && row.length > 0) {
        if (row && row[0].active === 0) {
          return res.status(200).json({
            status: "422",
            error: "Your account is not activated.",
          });
        } else {
              const theToken = jwt.sign({
                user_id,
              }, "the-super-strong-secrect", {});

            let name = row[0].name;
            let username = row[0].username;
            let company_uuid = row[0].company_uuid;
  
            let obj = {
              status: 201,
              message: "Signin successful",
              usertoken: theToken,
              id: row[0].user_id,
              uuid: row[0].uuid,
              username: username,
              name: name,
              type: row[0].type,
            };
  
            return res.status(201).json(obj);
         
        }
      } else {
        return res.status(200).json({
          status: "422",
          error: "Invalid Username or Password",
        });
      }
    } catch (err) {
      res.status(500).json({
        error: err,
      });
    }
  });

  router.post("/get-client-screenshot", authenticate, async (req, res) => {
    const { client_id, date } = req.body;
    
    try {
      
        let projsql = `SELECT project_id FROM projects_client WHERE client_id='${client_id}'  AND status=1`;
        
        const [projres] = await con.execute(projsql);
        // let newarr = []
        let attsql;
        let attres=[];
        if(projres.length>0){
            attsql = `SELECT * FROM attendance_jenyatracking WHERE proj_id in (${projres.map(x => `${x.project_id}`)})  AND date = '${date}' and is_proj_entry=1`;
            [attres] = await con.execute(attsql);
        }
        // console.log(attsql);
        
        const result = {};
        // console.log(attres);
        if(attres.length>0){
            let sql;
            for (let index = 0; index < attres.length; index++) {
              const element = attres[index];
              if(element.end_time!=='00:00:00'){
                sql = `SELECT * FROM screenshot WHERE proj_id in (${projres.map(x => `${x.project_id}`)}) and username in (${attres.map(x => `${x.username}`)})  AND date = '${date}' and proj_id!=0 and time>='${element.start_time}' and time<='${element.end_time}'`; 
              }else{
                sql = `SELECT * FROM screenshot WHERE proj_id in (${projres.map(x => `${x.project_id}`)})  and username in (${attres.map(x => `${x.username}`)})  AND date = '${date}' and proj_id!=0 and time>='${element.start_time}'`; 
              }
              
              let [result1] = await con.execute(sql);                     
              if(result1.length>0) { 
                for (const {
                  id,
                  username,
                  date,
                  hours,
                  time,
                  image_name,
                  active_window,
                  active_window_details,
                  clicks,
                  mouseevent,
                  keyboardevent,
                  diff_prev_ss,
                  proj_id,
                  act_id,
                  memo
                } of result1) {
                  // if (!result[hours]) result[hours] = [];
                  if (!result[username]) result[username] = [];
                  // console.log(proj_id,
                  //   act_id,
                  //   memo);]
                  let project="";
                  if(proj_id!=0){
                    let projsql = `SELECT name FROM projects WHERE project_id='${proj_id}'`;
                    const [projname] = await con.execute(projsql);
                    project = projname[0]?.name
                  }
                  let activity="";
                  if(act_id!=0){
                    let actsql = `SELECT activity_name FROM project_activity WHERE activity_id='${act_id}'`;
                    // console.log(actsql);
                    const [actdata] = await con.execute(actsql);
                    activity = actdata[0]?.activity_name
                  }

                  let usersql = `SELECT name FROM users WHERE username='${username}'`;
                  // console.log(actsql);
                  const [userdata] = await con.execute(usersql);
                  // console.log(proj_id);
                  result[username].push({
                    id,
                    name:userdata[0].name,
                    username,
                    date,
                    hours,
                    time,
                    image_name,
                    active_window,
                    active_window_details,
                    clicks,
                    mouseevent,
                    keyboardevent,
                    diff_prev_ss,
                    project,
                    activity,
                    memo
                  });
                }
              }
            }
        } 
        
       
      //   console.log(result);
      let sql2 = `SELECT * FROM activewin_icons`;  
      const [iconsresults] = await con.execute(sql2);

      if(attres.length>0){
        for (let index = 0; index < attres.length; index++) {
          const element = attres[index];
          let usersql = `SELECT name FROM users WHERE username = '${element.username}'`;
          const [userres] = await con.execute(usersql);
          attres[index].name = userres[0].name
          
          if(element.proj_id!=0){
            let projsql = `SELECT name FROM projects WHERE project_id = '${element.proj_id}'`;
            const [projres] = await con.execute(projsql);
            attres[index].project = projres[0].name
          }else{
            attres[index].project = ""
          }
          
          if(element.act_id!=0){
            let actsql = `SELECT activity_name FROM project_activity WHERE activity_id = '${element.act_id}'`;
            const [actres] = await con.execute(actsql);
            attres[index].activity = actres[0].activity_name
          }else{
            attres[index].activity = ""
          }

          let date1 = new Date(
            moment(element.date).format("YYYY-MM-DD") +
              " " +
              element.start_time
          );
          let date2 = new Date(
            moment(element.date).format("YYYY-MM-DD") +
              " " +
              element.end_time
          );
          let diff;
          if (element.end_time == "00:00:00") {
            diff = "00:00:00";
          } else {
            diff = timediff(date1, date2);
          }

          attres[index].duration = diff
         
        }
      }
      // console.log(attres);
      // return
  
      if (result) {
        res.status(201).json({
          status: 201,
          data: result,
          icons: iconsresults,
          attres,
        });
      } else {
        return res.status(200).json({
          status: "422",
          error: "No data available.",
        });
      }
    } catch (err) {
        console.log(err);
      res.status(500).json({
        error: err,
      });
    }
  });  

  router.post("/get-client-monthlywork", authenticate, async (req, res) => {
    let { client_id, month, year, } = req.body;
    
    if (month < 10) {
      month = "0" + month;
    }
    let startdate = year + "-" + month + "-01";
    const lastDay = new Date(
      new Date(startdate).getFullYear(),
      new Date(startdate).getMonth() + 1,
      0
    );
    let enddate = moment(lastDay).format("YYYY-MM-DD")
    // console.log(startdate);
    // console.log(enddate);
    // return
    try {

      let projsql = `SELECT project_id FROM projects_client WHERE client_id='${client_id}'  AND status=1`;
      const [projres] = await con.execute(projsql);
      let attres = [];      
      if(projres.length>0){
        let monthsql = `SELECT * FROM attendance_jenyatracking WHERE proj_id in (${projres.map(x => `${x.project_id}`)})  AND date >= '${startdate}' and date <= '${enddate}' and is_proj_entry=1`;
        [attres] = await con.execute(monthsql);
      }

      if(attres.length>0){
        for (let index = 0; index < attres.length; index++) {
          const element = attres[index];
          let usersql = `SELECT name FROM users WHERE username = '${element.username}'`;
          const [userres] = await con.execute(usersql);
          attres[index].name = userres[0].name
          
          if(element.proj_id!=0){
            let projsql = `SELECT name FROM projects WHERE project_id = '${element.proj_id}'`;
            const [projres] = await con.execute(projsql);
            attres[index].project = projres[0].name
          }else{
            attres[index].project = ""
          }
          
          if(element.act_id!=0){
            let actsql = `SELECT activity_name FROM project_activity WHERE activity_id = '${element.act_id}'`;
            const [actres] = await con.execute(actsql);
            attres[index].activity = actres ? actres[0]?.activity_name : ""
          }else{
            attres[index].activity = ""
          }

          let date1 = new Date(
            moment(element.date).format("YYYY-MM-DD") +
              " " +
              element.start_time
          );
          let date2 = new Date(
            moment(element.date).format("YYYY-MM-DD") +
              " " +
              element.end_time
          );
          let diff;
          if (element.end_time == "00:00:00") {
            diff = "00:00:00";
          } else {
            diff = timediff(date1, date2);
          }

          attres[index].duration = diff
         
        }


      }
      // console.log(attres);
      // return
  
      if (attres) {
        res.status(201).json({
          status: 201,
          attres,
        });
      } else {
        return res.status(200).json({
          status: "422",
          error: "No data available.",
        });
      }
    } catch (err) {
        console.log(err);
      res.status(500).json({
        error: err,
      });
    }
  });  


  
router.post("/save-hrs", authenticate, async (req, res) => {
  let { id, selectedproj,selectedact, Hrs, start_date, last_date } = req.body;
  
  try {
    let msg;
    if (id != undefined && id != "") {
      let sql = `update project_hrs set proj_id='${selectedproj}', act_id='${selectedact}', start_date='${start_date}', end_date='${last_date}', hrs='${Number(Hrs)}' where id='${id}'`;
      // console.log(sql);
      const [data] = await con.execute(sql);
      if (data) {
        res.status(201).json({
          status: 201,
          message: "Update successfully done",
        });
      } else {
        return res.status(200).json({
          status: "422",
          error: "Failed to Process",
        });
      }
    } else {
      let created_at = moment(new Date()).format("YYYY-MM-DD HH:MM:SS");
      // let uuid = uuidv4();
      let sql = `INSERT INTO project_hrs (proj_id,act_id, start_date, end_date,hrs, status,created_at) VALUES ('${Number(selectedproj)}','${Number(selectedact)}','${start_date}','${last_date}','${Number(Hrs)}',1,'${created_at}')`;
      // console.log(sql);
      const [data] = await con.execute(sql);

        if (data) {
        res.status(201).json({
          status: 201,
          message: "Insert successfully done",
        });
      } else {
        return res.status(200).json({
          status: "422",
          error: "Failed to Process",
        });
      }
    }
    
   
  } catch (err) {
    // console.log(err);
    res.status(500).json({
      error: err,
    });
  }
});

router.post("/delete-projecthrs", authenticate, async (req, res) => {
  let { id } = req.body;
  try {
    let sql = `delete FROM project_hrs where id=${id}`;
    const [row] = await con.execute(sql);
    if (row) {
      res.status(201).json({
        status: 201,
        msg: "Hrs record deleted successfully",
      });
    } else {
      return res.status(200).json({
        status: "422",
        msg: "Failed to delete.",
      });
    }
  } catch (err) {
    res.status(500).json({
      error: err,
    });
  }
});

// assign project

router.post("/getAllProjAssigned", authenticate, async (req, res) => {
  try {
    let sql = `SELECT
                projects_client.*,
                projects.name  as projname,
                clients.name as client,
                clients.email as clientemail
              FROM projects_client
             LEFT JOIN projects
                ON projects.project_id = projects_client.project_id
             LEFT JOIN clients
                ON clients.user_id = projects_client.client_id order by projects_client.id desc`;

    const [data] = await con.execute(sql);
    
    let projsql = `select project_id as value, name as label from projects where department=6 and status=1`;
    const [projects] = await con.execute(projsql);
    
    let clientsql = `select user_id as value, name as label from clients where department=6 and active=1`;
    const [clients] = await con.execute(clientsql);

    if (data.length > 0 || projects.length > 0) {
      res.status(201).json({
        status: 201,
        data,
        projects,
        clients
      });
    } else {
      return res.status(200).json({
        status: "422",
        error: "No data available.",
      });
    }
  } catch (err) {
    res.status(500).json({
      error: err,
    });
  }
});


router.post("/save-assignproject", authenticate, async (req, res) => {
  let { id, selectedproj, selectedclient } = req.body;
  
  try {
    let msg;
    if (id != undefined && id != "") {
      let updated_at = moment(new Date()).format("YYYY-MM-DD HH:MM:SS");
      let sql = `update projects_client set project_id='${Number(selectedproj)}', client_id='${Number(selectedclient)}', updated_at='${updated_at}' where id='${id}'`;
      // console.log(sql);
      const [data] = await con.execute(sql);
      if (data) {
        res.status(201).json({
          status: 201,
          message: "Update successfully done",
        });
      } else {
        return res.status(200).json({
          status: "422",
          error: "Failed to Process",
        });
      }
    } else {
      let created_at = moment(new Date()).format("YYYY-MM-DD HH:MM:SS");
      // let uuid = uuidv4();
      let sql = `INSERT INTO projects_client (client_id,project_id, status,created_at) VALUES ('${Number(selectedclient)}','${Number(selectedproj)}',1,'${created_at}')`;
      // console.log(sql);
      const [data] = await con.execute(sql);

        if (data) {
        res.status(201).json({
          status: 201,
          message: "Insert successfully done",
        });
      } else {
        return res.status(200).json({
          status: "422",
          error: "Failed to Process",
        });
      }
    }
    
   
  } catch (err) {
    // console.log(err);
    res.status(500).json({
      error: err,
    });
  }
});

router.post("/delete-AssignProjecttoClient", authenticate, async (req, res) => {
  let { id } = req.body;
  try {
    let sql = `delete FROM projects_client where id=${id}`;
    const [row] = await con.execute(sql);
    if (row) {
      res.status(201).json({
        status: 201,
        msg: "Data deleted successfully",
      });
    } else {
      return res.status(200).json({
        status: "422",
        msg: "Failed to delete.",
      });
    }
  } catch (err) {
    res.status(500).json({
      error: err,
    });
  }
});


router.post("/clients", authenticate, async (req, res) => {

  // const { role,department, listtype, usertype, type, master } = req.body;
  // console.log("role");
  try {
    let sql = `SELECT clients.*, departments.name as deptname FROM clients LEFT JOIN departments ON departments.department_id = clients.department where clients.active = 1 order by clients.user_id desc`;

    const [row] = await con.execute(sql);
        if (row.length > 0) {
          res.status(201).json({
            status: 201,
            data: row,
          });
        } else {
          return res.status(200).json({
            status: "422",
            error: "No data available.",
          });
        }

  } catch (err) {
    // console.log(err);
    res.status(500).json({
      error: err,
    });
  }
});


router.post("/add-client", async (req, res) => {
  let { id, name, department, password, contactno, email, status } = req.body.data;
// console.log(req.body.data);
  if (status == true) {
    status = 1;
  } else {
    status = 2;
  }

  try {
    let msg;
    let availsql = `SELECT * FROM clients where email = '${name}' and department = '${department}'`;
    const [availdata] = await con.execute(availsql);

    if (id != undefined || availdata.length > 0) {
      let sql;
      // console.log(password);
      if(req.body.data.password!="" && req.body.data.password==undefined){
        sql = `update clients set name='${name}', department=${department}, contact_no='${contactno}', email='${email}', active=${status} where user_id = '${id}'`;
      }else{
        let hash = createHash('sha256').update(password).digest('hex')
        sql = `update clients set password='${hash}', name='${name}', department=${department}, contact_no='${contactno}', email='${email}', active=${status} where user_id='${id}'`;
      }
      // console.log(sql)
      msg = "Client details Updated ";
      let [data] = await con.execute(sql);
      if (data) {
        res.status(201).json({
          status: 201,
          message: msg + " successfully",
        });
      } else {
        return res.status(200).json({
          status: "422",
          error: "Failed to Insert",
        });
      }
    } else {
        let hash;
        if(req.body.data.password!="" && req.body.data.password==undefined){
          hash = createHash('sha256').update('admin').digest('hex')
        }else{
          hash = createHash('sha256').update(password).digest('hex')
        }        
        let useruuid = uuidv4();
        let sql = `INSERT INTO clients (name, uuid, contact_no, email, password, active, department) VALUES ('${name}','${useruuid}','${contactno}','${email}', '${hash}','${status}',${department})`;

       let [data] = await con.execute(sql);        

        if (data) {
          return res.status(201).json({
            status: 201,
            message: "Client added successfully",
          });
        } else {
          return res.status(200).json({
            status: "422",
            error: "Failed to Insert",
            message: "Failed to Insert",
          });
        }    
    }
  } catch (err) {
    
    // console.log(err);
    res.status(500).json({
      error: err,
    });
  }
});


router.delete("/delete-client/:id", authenticate, async (req, res) => {
  // let { id } = req.body;
  try {
    let sql = `delete FROM clients where user_id=${req.params.id}`;
    const [row] = await con.execute(sql);
    if (row) {
      res.status(201).json({
        status: 201,
        msg: "Record deleted successfully",
      });
    } else {
      return res.status(200).json({
        status: "422",
        msg: "Failed to delete.",
      });
    }
  } catch (err) {
    res.status(500).json({
      error: err,
    });
  }
});

module.exports = router;



