// const { createHmac } = require("node:crypto");
const secret = "";
const express = require("express");
const router = express.Router();
const con = require("../db/conn").promise();
const jwt = require("jsonwebtoken");
const cors = require("cors");
const app = express();
const moment = require("moment");
const path = require("path");
const authenticate = require("../middleware/authenticate");
const { timediff, timetodec, dectotime } = require("../services/Time");
const multer = require("multer");
const fs = require("fs");
const { generateOTP } = require("../services/OTP");
const { v4: uuidv4 } = require("uuid");
const chech = require("../middleware/chech_sub");
const { log } = require("node:console");
const { createHash } = require('crypto');
app.use(express.urlencoded({ extended: true }));
app.use(cors());

// ################### document ##################################

router.post("/get-documents", authenticate, async (req, res) => {
  const uuid = req.body.uuid;
  try {
    const [row] = await con.execute(
      `SELECT username from users where uuid=? `,
      [uuid]
    );

    let ssrow = `select * FROM document_list where user_id = '${row[0].username}'`;
    
    const [finaldata] = await con.execute(ssrow);
// console.log(finaldata);

    let finalarr = [];
    for (let index = 0; index < finaldata.length; index++) {
      const element = finaldata[index];
      delete element["doclist_id"];
      delete element["user_id"];
      delete element["created_date"];
      delete element["updated_date"];
      finalarr.push(element)
    }

    if (finalarr.length > 0) {
      res.status(201).json({
        status: 201,
        data: finalarr,
      });
    } else {
      return res.status(200).json({
        status: "422",
        error: "No data available.",
      });
    }
  } catch (err) {
    res.status(500).json({
      error: err,
    });
  }
});

router.post("/get-documents", authenticate, async (req, res) => {
  const uuid = req.body.uuid;
  try {
    const [row] = await con.execute(
      "SELECT username from users where `user_id`=?",
      [uuid]
    );

    let ssrow = `select * FROM document_list where user_id = '${row[0].username}'`;
    const [finaldata] = await con.execute(ssrow);

    let finalarr = [];
    for (let index = 0; index < finaldata.length; index++) {
      const element = finaldata[index];
      delete element["doclist_id"];
      delete element["user_id"];
      delete element["created_date"];

      let obj = {
        title: element,
        uploaded_date: moment(element.updated_date).format(
          "YYYY-MM-DD HH:MM:SS"
        ),
      };
      delete element["updated_date"];
      finalarr.push(obj);
    }

    if (finalarr.length > 0) {
      res.status(201).json({
        status: 201,
        data: finalarr,
      });
    } else {
      return res.status(200).json({
        status: "422",
        error: "No data available.",
      });
    }
  } catch (err) {
    res.status(500).json({
      error: err,
    });
  }
});

// ################### manager detail  ##################################

router.post("/get-managerDetails", authenticate, async (req, res) => {
  const uuid = req.body.uuid;
  try {
    const [row] = await con.execute(
      "SELECT type, department from users where `uuid`=?",
      [uuid]
    );
    let finalarr = [];
    if(row[0].type!=1){
      let ssrow = `select * FROM users where department = '${row[0].department}' and type =1 and active=1`;
      const [finaldata] = await con.execute(ssrow);
      
      for (let index = 0; index < finaldata.length; index++) {
        const element = finaldata[index];
        let obj = {
          name: element.name,
          username: element.username,
          email: element.email,
          contact_no: element.contact_no,
          address: element.permanent_address,
          dob: moment(element.dob).format("YYYY-MM-DD"),
          blood_group: element.blood_group,
          height: element.height,
          weight: element.weight,
          date_of_joining: moment(element.date_of_joining).format("YYYY-MM-DD"),
        };
        finalarr.push(obj);
      }
    }
    if (finalarr.length > 0) {
      res.status(201).json({
        status: 201,
        data: finalarr,
      });
    } else {
      return res.status(200).json({
        status: "422",
        error: "No data available.",
      });
    }
  } catch (err) {
    res.status(500).json({
      error: err,
    });
  }
});

// ################### feeds ##################################

router.post("/get-feeds", authenticate, async (req, res) => {
  const company_uuid = req.body.company_uuid;
  const uuid = req.body.uuid;
  const date1 = req.body.date;
  const type = req.body.type;

  try {
    let date;
    if (date1 == "") {
      const d = new Date();
      date = moment(d).format("YYYY-MM-DD");
    } else {
      date = date1;
    }

    let ssrow;
    if (type === 0) {
      const [row] = await con.execute(
        "SELECT username from users where `uuid`=?",
        [uuid]
      );
      ssrow = `select attendance_jenyatracking.*, users.name, users.uuid FROM attendance_jenyatracking left join users on attendance_jenyatracking.username = users.username where  attendance_jenyatracking.username = '${row[0].username}' and attendance_jenyatracking.date ='${date}'`;
    }
    if (type === 1) {
      ssrow = `select attendance_jenyatracking.*, users.name, users.uuid FROM attendance_jenyatracking left join users on attendance_jenyatracking.username = users.username where attendance_jenyatracking.date ='${date}' and attendance_jenyatracking.company_uuid ='${company_uuid}'`;
    }
    // console.log(ssrow);
    const [finaldata] = await con.execute(ssrow);

    let finalarr = [];
    for (let index = 0; index < finaldata.length; index++) {
      const element = finaldata[index];

      for (let index = 0; index < 2; index++) {
        let action, time, time1;
        if (index == 0) {
          username = element.name;
          action = "Punch In";
          time =
            moment(element.date).format("YYYY-MM-DD") +
            " " +
            element.start_time;
          time1 =
            moment(element.date).format("YYYY-MM-DD") +
            " " +
            element.start_time;
        }
        if (index == 1) {
          username = element.name;
          action = "Punch Out";
          time =
            moment(element.date).format("YYYY-MM-DD") + " " + element.end_time;
          time1 =
            moment(element.date).format("YYYY-MM-DD") + " " + element.end_time;
        }

        let obj = {
          uuid: element.uuid,
          username: username,
          action: action,
          datetime: time,
          friendlydate: moment(time1).fromNow(),
        };
        if(element.end_time!='00:00:00'){
          finalarr.push(obj);
        }
      }
    }

    if (finalarr.length > 0) {
      res.status(201).json({
        status: 201,
        data: finalarr.reverse(),
      });
    } else {
      return res.status(200).json({
        status: "422",
        error: "No data available.",
      });
    }
  } catch (err) {
    res.status(500).json({
      error: err,
    });
  }
});

// ################### activity ##################################

router.post("/get-activity", authenticate, async (req, res) => {
  const uuid = req.body.uuid;
  const company_uuid = req.body.company_uuid;
  const date1 = req.body.date;
  try {
   
    let date;
    if (date1 == "") {
      const d = new Date();
      date = moment(d).format("YYYY-MM-DD");
    } else {
      date = date1;
    }

    let ssrow;
    if (uuid != "") {
      // console.log(uuid);
      const [row] = await con.execute(
        `SELECT username from users where uuid=?`,
        [uuid]
      );
      ssrow = `select screenshot.*, users.name FROM screenshot left join users on screenshot.username = users.username where screenshot.username = '${row[0].username}' and screenshot.date ='${date}' order by screenshot.id desc`;
    } else {
      ssrow = `select screenshot.*, users.name, users.username FROM screenshot left join users on screenshot.username = users.username where screenshot.date ='${date}' and screenshot.company_uuid ='${company_uuid}' order by screenshot.id desc`;
    }
    // console.log(ssrow);
    const [finaldata] = await con.execute(ssrow);
    // console.log(finaldata);
    let finalarr = [];
    for (let index = 0; index < finaldata.length; index++) {
      const element = finaldata[index];

      let obj = {
        employee: element.name,
        username: element.username,
        mouseclicked: element.clicks,
        mousescroll: element.mouseevent,
        keyboardclicked: element.keyboardevent,
        duration: element.diff_prev_ss,
        screenshot: element.image_name,
        date: moment(element.date).format("YYYY-MM-DD"),
        datetime:
          moment(element.date).format("YYYY-MM-DD") + " " + element.time,
      };
      finalarr.push(obj);
    }

    if (finalarr.length > 0) {
      res.status(201).json({
        status: 201,
        data: finalarr,
      });
    } else {
      return res.status(200).json({
        status: "422",
        error: "No data available.",
      });
    }
  } catch (err) {
    console.log(err);
    res.status(500).json({
      error: err,
    });
  }
});
// ################### leave summary ##################################

router.post("/get-leave-summary", authenticate, async (req, res) => {
  const uuid = req.body.uuid;
  const role = req.body.role;
  try {
    const [row] = await con.execute(
      "SELECT username,user_id from users where `uuid`=?",
      [uuid]
    );

    const d = new Date();
    let year = d.getFullYear();
    let fdate = year + "-01-01";

    let typesql = `select * FROM leavetype where status = 1`;
    const [typedata] = await con.execute(typesql);

    let finalarr = [];

    for (let index = 0; index < typedata.length; index++) {
      const element1 = typedata[index];
      let leaverow = `select * FROM leave_requests_new where user_id = '${row[0].user_id}' and start_date >='${fdate}' and leave_type like '%${element1.name}%'`;
      const [leavedata] = await con.execute(leaverow);
      let leavetypeval;
      // console.log(leavedata);
      if (element1.name == "LWP") {
        leavetypeval = 0;
      } else if (element1.name == "PL") {
        leavetypeval = 1;
      } else if (element1.name == "SL") {
        leavetypeval = 2;
      } else if (element1.name == "CL") {
        leavetypeval = 3;
      } else if (element1.name == "PTL") {
        leavetypeval = 4;
      } else if (element1.name == "MTL") {
        leavetypeval = 6;
      }

      let total = 0;
      leavedata.forEach((element) => {
        if (element.leavecountbytype != "") {
          let leavecountbytype = element.leavecountbytype.split(",");
          total = total + Number(leavecountbytype[leavetypeval]);
        }
      });

      let totalavail = 0;
      if (element1.name == "PL") {
        let plrow = `select * FROM user_leaves where user_id = '${row[0].user_id}'`;
        const [pldata] = await con.execute(plrow);

        totalavail = total + Number(pldata[0].PL);
      } else {
        totalavail = element1.no;
      }
      
      let obj = {
        type: element1.name,
        total: totalavail,
        taken: total,
        available: totalavail - total,
      };
      if(role==2){
        if(element1.name=='PL'){
          finalarr.push(obj);  
        }
      }else{
        finalarr.push(obj);
      }
    }

    if (finalarr) {
      res.status(201).json({
        status: 201,
        data: finalarr,
      });
    } else {
      return res.status(200).json({
        status: "422",
        error: "No data available.",
      });
    }
  } catch (err) {
    res.status(500).json({
      error: err,
    });
  }
});

router.post("/get-monthwise-leaves/:uuid", authenticate, async (req, res) => {
  // console.log(req.body);
  const uuid = req.body.uuid;
  let month = req.body.month;
  let year = req.body.year;
  let type = req.body.type;
  if (Number(month) < 10 && month.length == 1) {
    month = "0" + month;
  }
  let startdate = year + "-" + month + "-01";
  const lastDay = new Date(
    new Date(startdate).getFullYear(),
    new Date(startdate).getMonth() + 1,
    0
  );
  let enddate = moment(lastDay).format("YYYY-MM-DD");
  let sql;
  let finaldata;
  try {
    if (type == 0) {
      // const [row] = await con.execute(
      //   "SELECT user_id,uuid from users where `uuid`=?",
      //   [uuid]
      // );
      // console.log(row);
      sql = `select * FROM leave_requests_new where uuid = '${uuid}' and start_date >= '${startdate}' and start_date <= '${enddate}'`;
      // console.log(sql);
      const [data] = await con.execute(sql);  
      finaldata=data
    }
    if (type == 1) {

      let data=[]
      let user_sql= `SELECT * FROM users WHERE company_uuid='${req.body.uuid}'`
      const [data2] = await con.execute(user_sql);
      for (let i = 0; i < data2.length; i++) {
        const element = data2[i];
        sql = `select leave_requests_new.*,users.name, users.user_id, users.uuid FROM leave_requests_new left join users on leave_requests_new.user_id=users.user_id where leave_requests_new.start_date >= '${startdate}' and leave_requests_new.start_date <= '${enddate}' and  leave_requests_new.user_id=${element.user_id}  order by leave_requests_new.request_id desc`;
        const [data3] = await con.execute(sql); 
        if(data3.length>0){
          data.push(data3[0])
        } 
        
      }
      
      finaldata=data
     
    }
// console.log(sql);
    
    // const [data] = await con.execute(sql);
    
    

    if (finaldata.length > 0) {
      res.status(201).json({
        status: 201,
        data: finaldata,
      });
    } else {
      return res.status(200).json({
        status: "422",
        error: "No data available.",
      });
    }
  } catch (err) {
    // console.log(err);
    res.status(500).json({
      error: err,
    });
  }
});

// ################### attendance ##################################

router.post(
  "/get-monthwise-attendance/:uuid",
  authenticate,
  async (req, res) => {
    const uuid = req.params.uuid;
    let month = req.body.month;
    let company_uuid = req.body.company_uuid;
    let year = req.body.year;
    if (month < 10) {
      month = "0" + month;
    }
    let startdate = year + "-" + month + "-01";
    const lastDay = new Date(
      new Date(startdate).getFullYear(),
      new Date(startdate).getMonth() + 1,
      0
    );
    let enddate = moment(lastDay).format("YYYY-MM-DD");

    try {
      const [row] = await con.execute(
        "select * FROM `users` WHERE `uuid`=?",
        [uuid]
      );

      let sql = `select * FROM attendance_jenyatracking where username = '${row[0].username}' and date >= '${startdate}' and date <= '${enddate}'`;
      const [attdata] = await con.execute(sql);

      let sql1 = `SELECT * FROM screenshot WHERE username = '${row[0].username}' and date >='${startdate}' and date <='${enddate}' AND clicks=0 AND mouseevent=0 AND keyboardevent=0 AND diff_prev_ss!="" AND diff_prev_ss<="00:03:00"`;
      const [ssdata] = await con.execute(sql1);
      
      let curryear = moment(new Date()).format("YYYY");

      let holidaysql = `SELECT * FROM holidays WHERE uuid = '${row[0].company_uuid}' and year(date) ='${curryear}'`;
      const [holidays] = await con.execute(holidaysql);
      // console.log(holidaydata);

      if (attdata.length > 0) {
        let arr = [];
        let present = 0;
        let absent = 0;

        let todaydate = moment(new Date()).format("YYYY-MM-DD");
        let start = new Date(startdate);
        let end = new Date(enddate);
        let loop = new Date(start);
        while (loop <= end) {
          let date = moment(loop).format("YYYY-MM-DD");
          let datearr = [];
          // console.log(todaydate);
          attdata.forEach((element) => {
            if (date == moment(element.date).format("YYYY-MM-DD")) {
              datearr.push(element);
            }
          });

          let timedata = attdata.filter((item, i) => {
            return date == moment(item.date).format("YYYY-MM-DD");
          });

          let diffarr = [];
          if (timedata.length > 0) {
            timedata.forEach((element) => {
              let date1 = new Date(
                moment(element.date).format("YYYY-MM-DD") +
                  " " +
                  element.start_time
              );
              let date2 = new Date(
                moment(element.date).format("YYYY-MM-DD") +
                  " " +
                  element.end_time
              );
              let diff;
              if (element.end_time == "00:00:00") {
                diff = "00:00:00";
              } else {
                diff = timediff(date1, date2);
              }
              let dec = timetodec(diff);

              let obj = {
                prodtime: dec,
              };
              diffarr.push(obj);
            });
          }

          let totaldec = diffarr.reduce((a, b) => a + Number(b.prodtime), 0);

          let workingdec = totaldec;

          let workingdur = dectotime(workingdec * 60);

          let first_in =
            datearr && datearr.length > 0 ? datearr[0].start_time : "00:00:00";
          let last_out =
            datearr && datearr.length > 0
              ? datearr[datearr.length - 1].end_time
              : "00:00:00";

          if(first_in == "00:00:00"){
            let istodayholiday = holidays.filter((item)=>moment(item.date).format("YYYY-MM-DD")==todaydate)
            if(istodayholiday.length>0){
              first_in = "Holiday";
            }
            
            // var first = moment(date).startOf('month');
            function daysInMonth(month,year) {
              return new Date(year, month, 0).getDate();
            }

            var d = new Date(date);
            var getTot = daysInMonth(d.getMonth(),d.getFullYear());
            // console.log(daysInMonth(d.getMonth(),d.getFullYear()))
            var sat = new Array();
            var sun = new Array();

            for(var i=1;i<=getTot;i++){
                let newDate = new Date(d.getFullYear(),d.getMonth(),i)
                if(newDate.getDay()==0){
                  sun.push(moment(newDate).format("YYYY-MM-DD"))
                }
                if(newDate.getDay()==6){
                  sat.push(moment(newDate).format("YYYY-MM-DD"))
                }
                
            }

            let issunday = sun.filter((item)=>moment(item).format("YYYY-MM-DD")==date)
            // console.log(sun);
            if(issunday.length>0){
              first_in = "Weekof";
            }
            // console.log(sun);
            if(moment(sat[0]).format("YYYY-MM-DD")==date){
              first_in = "Weekof";
            }
            if(moment(sat[2]).format("YYYY-MM-DD")==date){
              first_in = "Weekof";
            }  
          }

          

          let obj = {
            date: date,
            first_in: first_in,
            last_out: last_out,
            entries:
              datearr && datearr.length > 0
                ? datearr[datearr.length - 1].punching_times
                : 0,

            duration: first_in!='Weekof' ? workingdur:"",
            onleave: "",
          };

          arr.push(obj);
          let newDate = loop.setDate(loop.getDate() + 1);
          loop = new Date(newDate);
        }

        let presentdata = attdata.filter((item, i) => {
          return item.start_time !== "00:00:00";
        });
        present = presentdata.length > 0 ? presentdata.length : 0;

        let absentdata = attdata.filter((item, i) => {
          return item.start_time === "00:00:00";
        });
        absent = absentdata.length > 0 ? absentdata.length : 0;

        let onleavesql = `select * FROM leave_requests_new where user_id = '${row[0].user_id}' and start_date >= '${startdate}' and start_date <= '${enddate}'`;
        const [onleavedata] = await con.execute(onleavesql);

        let onleave = 0;
        onleavedata.forEach((element) => {
          onleave = onleave + element.noofdays;
        });

        let holidaysql = `select * FROM monthlypresentreport2019 where monthname = '${moment(
          startdate
        ).format("DD-MM-YYYY")}'`;
        const [holidaydata] = await con.execute(holidaysql);

        res.status(201).json({
          status: 201,
          userdata: row,
          attdata: arr,
          present: present,
          absent: absent,
          onleave: Number(onleave),
          holiday: Number(holidaydata[0].monthholiday),
        });
      } else {
        return res.status(200).json({
          status: "422",
          error: "No data available.",
        });
      }
    } catch (err) {
      console.log(err);
      res.status(500).json({
        error: err,
      });
    }
  }
);

// ################### employee detail  ##################################

router.post("/getUserDetails/:uuid", authenticate, async (req, res) => {
  const uuid = req.params.uuid;
  const { type } = req.body;

  try {
    if (type == 0) {
      const [row] = await con.execute(
        `SELECT users.*, departments.name as deptname FROM users LEFT JOIN departments ON departments.department_id = users.department where users.uuid=?  `,
        [uuid]
      );
// console.log(row);
      if (row.length > 0) {
        const [attdata] = await con.execute(
          // `select * FROM attendance_jenyatracking WHERE username=? order by id desc `,
          // [row[0].username]
          `SELECT attendance_jenyatracking.*, attendance_tickets.status as ticketstatus,attendance_tickets.attendance_id as attendance_id, attendance_tickets.start_time as ticketStarttime, attendance_tickets.end_time  as ticketEndtime FROM attendance_jenyatracking left join attendance_tickets ON attendance_tickets.attendance_id = attendance_jenyatracking.id where attendance_jenyatracking.username=?  order by attendance_jenyatracking.id desc`,
          [row[0].username]
        );
        res.status(201).json({
          status: 201,
          userdata: row,
          attdata: attdata,
        });
      } else {
        return res.status(200).json({
          status: "422",
          error: "No data available.",
        });
      }
    }

    if (type == 1) {
      const [row] = await con.execute(
        `select attendance_jenyatracking.*, users.name, users.uuid FROM attendance_jenyatracking LEFT JOIN users on attendance_jenyatracking.username = users.username where users.company_uuid='${req.body.uuid}'  order by id desc`
      );

      

      if (row.length > 0) {
        res.status(201).json({
          status: 201,
          attdata: row,
        });
      } else {
        return res.status(200).json({
          status: "422",
          error: "No data available.",
        });
      }
    }
  } catch (err) {
    console.log(err);
    res.status(500).json({
      error: err,
    });
  }
}); 



router.post("/getUserBreakDetails/:uuid", authenticate, async (req, res) => {
  const uuid = req.params.uuid;
  const { type } = req.body;

  try {
    if (type == 0) {
      const [row] = await con.execute(
        `SELECT users.*, departments.name as deptname FROM users LEFT JOIN departments ON departments.department_id = users.department where users.uuid=?  `,
        [uuid]
      );
// console.log(row);
      if (row.length > 0) {
        const [attdata] = await con.execute(
          // `select * FROM attendance_breaks_jenyatracking WHERE username=? order by id desc `,
          // [row[0].username]
          `SELECT attendance_breaks_jenyatracking.*, attendance_tickets.status as ticketstatus,attendance_tickets.attendance_id as attendance_id, attendance_tickets.start_time as ticketStarttime, attendance_tickets.end_time  as ticketEndtime FROM attendance_breaks_jenyatracking left join attendance_tickets ON attendance_tickets.attendance_id = attendance_breaks_jenyatracking.id where attendance_breaks_jenyatracking.username=?  order by attendance_breaks_jenyatracking.id desc`,
          [row[0].username]
        );
        res.status(201).json({
          status: 201,
          userdata: row,
          attdata: attdata,
        });
      } else {
        return res.status(200).json({
          status: "422",
          error: "No data available.",
        });
      }
    }

    if (type == 1) {
      const [row] = await con.execute(
        `select attendance_breaks_jenyatracking.*, users.name, users.uuid FROM attendance_breaks_jenyatracking LEFT JOIN users on attendance_breaks_jenyatracking.username = users.username where users.company_uuid='${req.body.uuid}'  order by id desc`
      );

      

      if (row.length > 0) {
        res.status(201).json({
          status: 201,
          attdata: row,
        });
      } else {
        return res.status(200).json({
          status: "422",
          error: "No data available.",
        });
      }
    }
  } catch (err) {
    // console.log(err);
    res.status(500).json({
      error: err,
    });
  }
}); 
// ################### login ##################################

router.post("/admin-signin", async (req, res) => {
  try {
    const { type, user_id, password } = req.body;
    if (!user_id || !password) {
      return res.status(200).json({
        error: "Please Enter Value",
      });
    }

    // console.log(createHash('sha256').update(password).digest('hex')); return
    // let sql = "SELECT users.*, departments.name as deptname FROM users LEFT JOIN departments ON departments.department_id = users.department where `username`=? and `password`=?"
    // let sql = `SELECT * FROM users WHERE username=${user_id}`;
    const [row] = await con.execute(
      "SELECT users.*, departments.name as deptname FROM users LEFT JOIN departments ON departments.department_id = users.department where `username`=? and `password`=?",
      [user_id,createHash('sha256').update(password).digest('hex')]
  );
// console.log(user_id,createHash('sha256').update(password).digest('hex')); return
    // const [row] = await con.execute(sql);
    // const hash = createHmac("sha256", "40").update(password).digest("hex");
    // const hash = createHash('sha256').update(password).digest('hex');
// console.log(hash);
    if (row && row.length > 0) {
      if (row && row[0].active === 0) {
        return res.status(200).json({
          status: "422",
          error: "Your account is not activated.",
        });
      } else {
        let check_sub = await chech(row[0].company_uuid);
        // console.log(check_sub); return
        if (check_sub === true || row[0].master === 1) {
          const theToken = jwt.sign(
            {
              user_id,
            },
            "the-super-strong-secrect",
            {}
          );
          let name = row[0].name;
          let username = row[0].username;
          let company_uuid = row[0].company_uuid;

          let sql = `SELECT * FROM companies where uuid='${company_uuid}'`;
          const [companydata] = await con.execute(sql);
          
          let appsql = `SELECT value FROM app_settings where name='APP_VERSION'`;
          const [appdata] = await con.execute(appsql);

          let obj = {
            status: 201,
            message: "Signin successful",
            usertoken: theToken,
            id: row[0].user_id,
            uuid: row[0].uuid,
            department: row[0].department,
            username: username,
            name: name,
            avatar: row[0].avatar,
            role: row[0].type,
            timezone: "",
            dept: row[0].deptname,
            companydata,
            master: row[0].master,
            type: row[0].type,
            app_version: appdata[0].value,
          };

          return res.status(201).json(obj);
        } else {
          return res.status(200).json({
            status: "422",
            error: "Your subscription is expired. Please contact Adminstrator",
          });
        }
      }
    } else {
      return res.status(200).json({
        status: "422",
        error: "Invalid Username or Password",
      });
    }
  } catch (err) {
    console.log(err);
    res.status(500).json({
      error: err,
    });
  }
});

// ################### all employee ##################################
router.post("/admin-Employee", authenticate, async (req, res) => {

  // const { role,department, listtype, usertype, type, master } = req.body;
  // console.log("role");
  try {
    let sql = `SELECT users.*, departments.name as deptname FROM users LEFT JOIN departments ON departments.department_id = users.department where users.active = 1 and users.company_uuid='${req.body.uuid}' order by users.user_id desc`;

    const [row] = await con.execute(sql);
        if (row.length > 0) {
          res.status(201).json({
            status: 201,
            data: row,
          });
        } else {
          return res.status(200).json({
            status: "422",
            error: "No data available.",
          });
        }

  } catch (err) {
    console.log(err);
    res.status(500).json({
      error: err,
    });
  }
});

// ################### register ##################################

router.post("/signup", async (req, res) => {
  const { sendMail } = require("../services/MAIL");
  const { type, firstname, lastname, username, email, password } = req.body;
  if (!email || !password) {
    return res.status(422).json({
      status: "422",
      error: "Please Enter Value",
    });
  }

  try {
    const [row] = await con.execute(
      "SELECT `email` FROM `users` WHERE `email`=?",
      [email]
    );

    if (row.length > 0) {
      return res.status(201).json({
        status: 422,
        error: "The E-mail already in use",
      });
    }

    const [checkusername] = await con.execute(
      "SELECT `username` FROM `users` WHERE `username`=?",
      [username]
    );

    if (checkusername.length > 0) {
      return res.status(201).json({
        status: 422,
        error: "This Username already in use",
      });
    }

    const otpGenerated = generateOTP();
    let uuid = uuidv4();

    let authtoken = crypto.randomBytes(16).toString("hex");

    // const hash = createHmac("sha256", secret).update(password).digest("hex");
    const hash = createHash('sha256').update(password).digest('hex');

    let sql = `INSERT INTO users (uuid, firstname,lastname, username, email, password, otp, auth_token) VALUES ('${uuid}','${firstname}','${lastname}','${username}','${email}', '${hash}','${otpGenerated}','${authtoken}')`;

    const [result] = await con.execute(sql);
    if (result.affectedRows === 1) {
      const theToken = jwt.sign(
        {
          email,
        },
        "the-super-strong-secrect",
        {}
      );
      await sendMail({
        uuid: uuid,
        to: email,
        OTP: otpGenerated,
      });
      res.status(201).json({
        status: 201,
        message: "User Registration successfully",
        token: theToken,
        uuid: uuid,
      });
    }
  } catch (err) {
    res.status(500).json({
      error: "Failed to Register.",
    });
  }
});

router.post("/verify-email", async (req, res) => {
  const { uuid, otp } = req.body;

  try {
    const [row] = await con.execute(
      "SELECT `id`,`email`,`otp`,`status` FROM `users` WHERE `uuid`=?",
      [uuid]
    );

    if (row.length == 0) {
      return res.status(201).json({
        status: 422,
        error: "User not found",
      });
    }

    if (row && row[0].status == 1) {
      return res.status(201).json({
        status: 422,
        error: "User Already Activated",
      });
    }

    if (row && row[0].otp !== otp) {
      return res.status(201).json({
        status: 422,
        error: "Invalid OTP",
      });
    } else {
      let sql = `UPDATE users set status = 1 where id='${row[0].id}'`;
      const [result] = await con.execute(sql);

      if (result.affectedRows === 1) {
        res.status(201).json({
          status: 201,
          message: "User activated successfully",
        });
      } else {
        res.status(500).json({
          error: "Failed to activate.",
        });
      }
    }
  } catch (err) {
    res.status(500).json({
      error: "Failed to activate.",
    });
  }
});

router.post("/resend-otp", async (req, res) => {
  const { uuid, type } = req.body;

  try {
    const [row] = await con.execute(
      "SELECT `id`,`email`,`status` FROM `users` WHERE `uuid`=?",
      [uuid]
    );

    if (row.length == 0) {
      return res.status(201).json({
        status: 422,
        error: "User not found",
      });
    }

    const otpGenerated = generateOTP();
    let sent;
    if (type == 1) {
      const { sendMail } = require("../services/MAIL");
      if (row && row[0].status == 1) {
        return res.status(201).json({
          status: 422,
          error: "User Already Activated",
        });
      }

      sent = await sendMail({
        uuid: uuid,
        to: row[0].email,
        OTP: otpGenerated,
      });
    }

    if (type == 2) {
      const { sendMail } = require("../services/FORGOTPASSMAIL");
      sent = await sendMail({
        uuid: uuid,
        to: row[0].email,
        OTP: otpGenerated,
      });
    }

    let sql = `UPDATE users set otp = '${otpGenerated}' where uuid='${uuid}'`;
    await con.execute(sql);

    if (sent) {
      res.status(201).json({
        status: 201,
        message: "OTP sent successfully",
      });
    } else {
      res.status(500).json({
        error: "Failed to send otp.",
      });
    }
  } catch (err) {
    res.status(500).json({
      error: "Failed to send otp.",
    });
  }
});

router.post("/verify-forgotpassword", async (req, res) => {
  const { uuid, otp, password } = req.body;
  try {
    const [row] = await con.execute(
      "SELECT `id`,`email`,`otp`,`status` FROM `users` WHERE `uuid`=?",
      [uuid]
    );

    if (row.length == 0) {
      return res.status(201).json({
        status: 422,
        error: "No user found",
      });
    }

    if (row && row[0].otp !== otp) {
      return res.status(201).json({
        status: 422,
        error: "Invalid OTP",
      });
    } else {
      const hash = createHash('sha256').update(password).digest('hex');
      let sql = `UPDATE users set password = '${hash}' where uuid='${uuid}'`;
      const [result] = await con.execute(sql);

      if (result.affectedRows === 1) {
        res.status(201).json({
          status: 201,
          message: "Password changed successfully",
        });
      } else {
        res.status(500).json({
          error: "Failed to change password.",
        });
      }
    }
  } catch (err) {
    res.status(500).json({
      error: "Failed to change password.",
    });
  }
});

router.post("/forgot-password", async (req, res) => {
  const { sendMail } = require("../services/FORGOTPASSMAIL");
  const { email } = req.body;

  try {
    const [row] = await con.execute(
      "SELECT `uuid`,`email` FROM `users` WHERE `email`=?",
      [email]
    );

    if (row.length == 0) {
      return res.status(201).json({
        status: 422,
        error: "No User Found",
      });
    }
    const otpGenerated = generateOTP();

    let sql = `UPDATE users set otp = '${otpGenerated}' where uuid='${row[0].uuid}'`;
    await con.execute(sql);

    await sendMail({
      uuid: row[0].uuid,
      to: email,
      OTP: otpGenerated,
    });

    res.status(201).json({
      status: 201,
      message: "OTP sent",
      uuid: row[0].uuid,
    });
  } catch (err) {
    res.status(500).json({
      error: "Failed to sent OTP.",
    });
  }
});

router.get("/getProfileDatabyuser/:id", authenticate, async (req, res) => {
  const id = req.params.id;
  try {
    const [row] = await con.execute("select * FROM `users` WHERE `id`=?", [id]);

    if (row.length > 0) {
      res.status(201).json({
        status: 201,
        data: row,
      });
    } else {
      return res.status(200).json({
        status: "422",
        error: "No data available.",
      });
    }
  } catch (err) {
    res.status(500).json({
      error: err,
    });
  }
});

router.get("/get-companydata/:id", authenticate, async (req, res) => {
  const id = req.params.id;
  try {
    const [row] = await con.execute("select * FROM `companies` WHERE `uuid`=?", [id]);

    if (row.length > 0) {
      res.status(201).json({
        status: 201,
        data: row,
      });
    } else {
      return res.status(200).json({
        status: "422",
        error: "No data available.",
      });
    }
  } catch (err) {
    res.status(500).json({
      error: err,
    });
  }
});

router.post("/admin-addNewUser", authenticate, async (req, res) => {
  const {
    firstname,
    lastname,
    email,
    user_type,
    balance,
    credit_limit,
    pin,
    role,
  } = req.body.values;
  if (!firstname || !email) {
    return res.status(422).json({
      status: "422",
      error: "Please Enter Value",
    });
  }

  try {
    const [row] = await con.execute(
      "SELECT `email` FROM `users` WHERE `email`=?",
      [email]
    );

    if (row.length > 0) {
      return res.status(422).json({
        status: 422,
        message: "The E-mail already in use",
      });
    }
    const password = "didbiz";
    let name = firstname + " " + lastname;
    const hash = createHash('sha256').update(password).digest('hex');
    const username = name.replace(/ /g, "_");

    let uuid = uuidv4();

    let sql = `INSERT INTO users (uuid, firstname, lastname, username,  email, password, user_type, balance, credit_limit, pincode, role, status) VALUES ('${uuid}', '${firstname}', '${lastname}', '${username}', '${email}', '${hash}', '${user_type}', '${balance}', '${credit_limit}', '${pin}', '${role}','1')`;

    const [result] = await con.execute(sql);
    if (result.affectedRows === 1) {
      res.status(201).json({
        status: 201,
        message: "User Added successfully",
      });
    }
  } catch (err) {
    res.status(500).json({
      message: "Failed to Add user. Please try again",
    });
  }
});

router.post(
  "/admin-saveProfileDetails/:uuid",
  authenticate,
  async (req, res) => {
    const uuid = req.params.uuid;

    const {
      firstname,
      lastname,
      username,
      email,
      dateOfBirth,
      phoneNumber,
      website,
      address,
      city,
      state,
      postcode,
      timezone,
    } = req.body.values;
    if (!firstname || !email || !username) {
      return res.status(422).json({
        status: "422",
        error: "Please Enter Value",
      });
    }

    try {
      const [row] = await con.execute(
        "SELECT `email` FROM `users` WHERE `email`=? and uuid!=?",
        [email, uuid]
      );

      if (row.length > 0) {
        return res.status(422).json({
          status: 422,
          error: "The E-mail already in use",
        });
      }

      const [checkusername] = await con.execute(
        "SELECT `username` FROM `users` WHERE `username`=? and uuid!=?",
        [username, uuid]
      );

      if (checkusername.length > 0) {
        return res.status(201).json({
          status: 422,
          error: "This Username already in use",
        });
      }

      let sql = `UPDATE users set firstname = '${firstname}', lastname = '${lastname}', username = '${username}', email = '${email}', dob = '${moment(
        dateOfBirth
      ).format(
        "YYYY-MM-DD"
      )}', timezone='${timezone}',  phone = '${phoneNumber}', website = '${website}', address = '${address}', city='${city}', state='${state}', pincode='${postcode}' where uuid='${uuid}'`;

      const [result] = await con.execute(sql);
      if (result.affectedRows === 1) {
        res.status(201).json({
          status: 201,
          message: "Profile Updated successfully",
        });
      }
    } catch (err) {
      res.status(500).json({
        message: "Failed to update profile.",
      });
    }
  }
);

router.post("/admin-updateUser", authenticate, async (req, res) => {
  const {
    id,
    firstname,
    lastname,
    email,
    user_type,
    balance,
    credit_limit,
    pin,
    role,
    is_sip_trunk,
    status,
  } = req.body.values;
  if (!firstname || !email) {
    return res.status(422).json({
      status: "422",
      error: "Please Enter Value",
    });
  }

  try {
    const [row] = await con.execute(
      "SELECT `email` FROM `users` WHERE `email`=? and id!=?",
      [email, id]
    );

    if (row.length > 0) {
      return res.status(422).json({
        status: 422,
        message: "The E-mail already in use",
      });
    }

    let sql = `UPDATE users set firstname = '${firstname}', lastname = '${lastname}', email = '${email}', user_type = '${user_type}', balance = '${balance}', credit_limit = '${credit_limit}', pincode = '${pin}', role='${role}', is_sip_trunk='${is_sip_trunk}', status='${status}' where id='${id}'`;

    const [result] = await con.execute(sql);
    if (result.affectedRows === 1) {
      res.status(201).json({
        status: 201,
        message: "User Updated successfully",
      });
    }
  } catch (err) {
    res.status(500).json({
      message: "Failed to Update user.",
    });
  }
});

router.delete("/admin-deleteUser/:uuid", authenticate, async (req, res) => {
  const id = req.params.uuid;
  try {
    const [row] = await con.execute("DELETE FROM `users` WHERE `uuid`=?", [id]);
    if (row.affectedRows === 1) {
      res.status(201).json({
        status: 201,
        message: "User deleted successfully",
      });
    }
  } catch (err) {
    res.status(500).json({
      message: "Failed to Delete user.",
    });
  }
});

imagesName = [];
let obj;
const storage = multer.diskStorage({
  destination: (req, res, callback) => {
    let path = `./uploads/avatar`;
    if (!fs.existsSync(path)) {
      fs.mkdirSync(path, {});
    }
    callback(null, path);
  },
  filename: (req, file, callback) => {
    let filename =
      file.fieldname + Date.now() + path.extname(file.originalname);

    callback(null, filename);
    imagesName.push(filename);
  },
});

const upload = multer({
  storage: storage,
});

router.post("/uploadAvatar/:id", upload.array("file"), async (req, res) => {
  const id = req.params.id;
  try {
    let sql = `UPDATE users set avatar='${imagesName}' where id='${id}'`;

    await con.execute(sql);

    res.status(201).json({
      status: 201,
      message: "Image Uploaded successfully",
      imagesName: imagesName,
    });
    imagesName = [];
  } catch (err) {
    res.status(500).json({
      error: "Failed to Upload Image.",
    });
  }
});



router.post("/get-organizations", authenticate, async (req, res) => {
  let month = req.body.month;
  let year = req.body.year;
  if (month < 10) {
    month = "0" + month;
  }

  try {
    let sql = `select uuid as value, name as label FROM companies where active = 1`;
    const [data] = await con.execute(sql);

    if (data.length > 0) {
      res.status(201).json({
        status: 201,
        data: data,
      });
    } else {
      return res.status(200).json({
        status: "422",
        error: "No data available.",
      });
    }
  } catch (err) {
    res.status(500).json({
      error: err,
    });
  }
});




router.get("/signup-organization", async(req, res) => {
  // console.log(req.body); return
  let { name, email, mobile } = req.body;
  try {
    let checksql = `SELECT * FROM companies WHERE support_contact='${email}'`;
    let [master] = await con.execute(checksql);

    if (master.length>0 === 1) {
        message = "Organization already available";
    } else {
        let uuid = uuidv4();
        let expiry = moment(new Date()).format("YYYY-MM-DD HH:MM:SS");
        let sql3 = `INSERT INTO  companies (uuid,name,phone,support_contact,support_access,account_manager,city,user_count,expiry_date, active) VALUES ('${uuid}','${name}',${mobile},'${email}',1,"","",0,'${expiry}',1) `;
        [data] = await con.execute(sql3);

        message = "Organization Registration successfully done";
      }

      if (data) {
        res.status(201).json({
          status: 201,
          message: message,
        });
      } else {
        return res.status(200).json({
          status: "422",
          message: "Failed to Add",
        });
      }   
  } catch (err) {
    // console.log(err);
    res.status(500).json({
      error: err,
    });
  }
});


module.exports = router;




