const express = require("express");
// const { createHmac } = require("node:crypto");
const secret = "abcdefg";
const router = express.Router();
const con = require("../db/conn").promise();
const moment = require("moment");
const authenticate = require("../middleware/authenticate");
const multer = require("multer");
const { v4: uuidv4 } = require("uuid");
const chech = require("../middleware/chech_sub");
const fs = require("fs");
const path = require("path");
const { createHash } = require('crypto');

let imagesName;
imagesName = [];
const storage = multer.diskStorage({
  destination: (req, res, callback) => {
    let path = `./uploads/orglogo`;
    if (!fs.existsSync(path)) {
      fs.mkdirSync(path, {});
    }
    callback(null, path);
  },
  filename: (req, file, callback) => {
    let filename =
      file.fieldname + Date.now() + path.extname(file.originalname);
    callback(null, filename);
    imagesName.push(filename);
  },
});

const upload = multer({
  storage: storage,
});

router.post("/addorganization", authenticate, async (req, res) => {
  let { name, email, mobile, status, user, expiry, uuid, username } = req.body.data;
  if(status==true){
    status=1
  }else{
    status=2
  }
  try {
    let checksql = `SELECT * FROM users WHERE username=${JSON.parse(
      req.body.username
    )}`;
    let [master] = await con.execute(checksql);

    if (master[0].master === 1) {
      let message;
      let data;
      if (uuid != null) {
        // support_access=${supportaccess}
        let sql = `update companies set name='${name}', support_contact='${email}', phone='${mobile}', user_count='${user}', expiry_date='${expiry}', active='${status}' where uuid='${uuid}'`;
        // console.log(sql);
        [data] = await con.execute(sql);
        message = "Organization Updated successfully";
      } else {
        let uuid = uuidv4();
        // let sql2 = `INSERT INTO  subscribed_organization(organization_name,uuid,email,mobile_no,user_count,expiry_date) VALUES ('${name}','${uuid}','${email}',${mobile},${user},'${expiry}')`;
        // [data] = await con.execute(sql2);
        
        let sql3 = `INSERT INTO  companies (uuid,name,phone,support_contact,support_access,account_manager,city,user_count,expiry_date, active) VALUES ('${uuid}','${name}',${mobile},'${email}',1,"","",${user},'${expiry}',1) `;
        [data] = await con.execute(sql3);

        message = "Organization Added successfully";
      }

      if (data) {
        res.status(201).json({
          status: 201,
          message: message,
        });
      } else {
        return res.status(200).json({
          status: "422",
          message: "Failed to update",
        });
      }
    } else {
      res.status(500).json({
        message: "You are not authorized",
      });
    }
  } catch (err) {
    console.log(err);
    res.status(500).json({
      error: err,
    });
  }
});



//################## add subscribed org ######################################

router.get("/addorganization", authenticate, async (req, res) => {
  let sql = `SELECT * FROM companies order by id desc`;
  let [data] = await con.execute(sql);
  res.status(201).json({
    status: 201,
    data: data,
  });
});

router.post("/save-orgdetails", upload.array("image"), async (req, res) => {
    let { company_uuid, name, supportaccess } = req.body;
    let imagename = "";
    if (imagesName[0] != undefined) {
      imagename = imagesName[0];
    }
    try {
      var sql = `update companies set name='${name}', orglogo='${imagename}', support_access=${supportaccess} where uuid = '${company_uuid}'`;
      // console.log(sql);
      const [data] = await con.execute(sql);
      if (data) {
        res.status(201).json({
          status: 201,
          message: "Update success",
          logo: imagename,
        });
      } else {
        return res.status(200).json({
          status: "422",
          error: "Failed to update",
        });
      }
    } catch (err) {
      res.status(500).json({
        error: err,
      });
    }
  }
);

//######################  department ##############################

router.post("/save-department", authenticate, async (req, res) => {
  let { id, name, hod, status } = req.body.data;
  if (status == true) {
    status = 1;
  } else {
    status = 0;
  }
  try {
    let availsql = `SELECT * FROM departments where name = '${name}' and uuid='${req.body.company_uuid}' `;
    let sql;
    const [availdata] = await con.execute(availsql);
    let msg;
    if (id != undefined || availdata.length > 0) {
      sql = `update departments set name='${name}', manager=${hod}, active=${status} where department_id = '${id}' and uuid='${req.body.company_uuid}' `;
      msg = "Update";
    } else {
      sql = `INSERT INTO departments (name, manager,active,uuid) VALUES ('${name}','${hod}','${status}','${req.body.company_uuid}')`;
      msg = "Insert";
    }
    const [data] = await con.execute(sql);
    if (data) {
      res.status(201).json({
        status: 201,
        message: msg + " success",
      });
    } else {
      return res.status(200).json({
        status: "422",
        error: "Failed to Insert",
      });
    }
  } catch (err) {
    res.status(500).json({
      error: err,
    });
  }
});

router.post("/getAllDepartments", authenticate, async (req, res) => {
  try {
    let sql = `SELECT departments.name as deptname,departments.department_id,departments.manager,departments.active FROM departments  where departments.uuid='${req.body.uuid}' order by departments.department_id desc`;
    //, users.name right JOIN users ON departments.uuid = users.company_uuid
    // console.log(sql);
    const [row] = await con.execute(sql);

    if (row.length > 0) {
      res.status(201).json({
        status: 201,
        data: row,
      });
    } else {
      return res.status(200).json({
        status: "422",
        error: "No data available.",
      });
    }
  } catch (err) {
    res.status(500).json({
      error: err,
    });
  }
});

router.post("/delete-department", authenticate, async (req, res) => {
  let { id } = req.body;
  try {
    let sql = `delete FROM departments where department_id=${id}`;
    const [row] = await con.execute(sql);
    if (row) {
      res.status(201).json({
        status: 201,
        msg: "Record deleted successfully",
      });
    } else {
      return res.status(200).json({
        status: "422",
        msg: "Failed to delete.",
      });
    }
  } catch (err) {
    res.status(500).json({
      error: err,
    });
  }
});

//############################# designation ####################################

router.post("/save-designations", authenticate, async (req, res) => {
  let { id, name, hod, status } = req.body.data;

  if (status == true) {
    status = 1;
  } else {
    status = 0;
  }
  try {
    let availsql = `SELECT * FROM designations where name = '${name}'`;
    let sql;
    const [availdata] = await con.execute(availsql);
    let msg;
    if (id != undefined || availdata.length > 0) {
      sql = `update designations set name='${name}', department=${hod}, active=${status} where designation_id = '${id}'`;
      msg = "Update";
    } else {
      sql = `INSERT INTO designations (name, department,active,uuid) VALUES ('${name}','${hod}','${status}','${req.body.company_uuid}')`;
      msg = "Insert";
    }
    const [data] = await con.execute(sql);
    if (data) {
      res.status(201).json({
        status: 201,
        message: msg + " success",
      });
    } else {
      return res.status(200).json({
        status: "422",
        error: "Failed to Insert",
      });
    }
  } catch (err) {
    res.status(500).json({
      error: err,
    });
  }
});

router.post("/getAllDesignations", authenticate, async (req, res) => {
  try {
    let sql = `SELECT designations.designation_id, designations.name as designame,designations.active, departments.department_id,departments.name FROM designations JOIN departments ON designations.department = departments.department_id where designations.uuid='${req.body.uuid}' order by designations.designation_id desc`;
    const [row] = await con.execute(sql);
    if (row.length > 0) {
      res.status(201).json({
        status: 201,
        data: row,
      });
    } else {
      return res.status(200).json({
        status: "422",
        error: "No data available.",
      });
    }
  } catch (err) {
    res.status(500).json({
      error: err,
    });
  }
});

router.post("/delete-designation", authenticate, async (req, res) => {
  let { id } = req.body;
  try {
    let sql = `delete FROM designations where designation_id=${id}`;
    const [row] = await con.execute(sql);
    if (row) {
      res.status(201).json({
        status: 201,
        msg: "Record deleted successfully",
      });
    } else {
      return res.status(200).json({
        status: "422",
        msg: "Failed to delete.",
      });
    }
  } catch (err) {
    res.status(500).json({
      error: err,
    });
  }
});

//###################### add employee ####################################

router.post("/add-user", async (req, res) => {
  let { id, name, department, password, organization, hod, contactno, email, status } = req.body.data;
// console.log(req.body.data);
  if (status == true) {
    status = 1;
  } else {
    status = 2;
  }

  try {
    let msg;
    let availsql = `SELECT * FROM users where name = '${name}' and department = '${department}'`;
    const [availdata] = await con.execute(availsql);

    if (id != undefined || availdata.length > 0) {
      let sql;
      // console.log(password);
      if(req.body.data.password!="" || req.body.data.password==undefined){
        sql = `update users set name='${name}', department=${department}, type='${hod}', contact_no='${contactno}', email='${email}', active=${status} where user_id = '${id}'`;
      }else{
        let hash = createHash('sha256').update(password).digest('hex')
        // console.log(hash);

        sql = `update users set password='${hash}', company_uuid='${organization}', name='${name}', department=${department}, type='${hod}', contact_no='${contactno}', email='${email}', active=${status} where user_id = '${id}'`;
      }
      // console.log(sql)
      msg = "Employee details Updated ";
      let [data] = await con.execute(sql);
      if (data) {
        res.status(201).json({
          status: 201,
          message: msg + " successfully",
        });
      } else {
        return res.status(200).json({
          status: "422",
          error: "Failed to Insert",
        });
      }
    } else {
      let lastsql = `SELECT username FROM users order by user_id desc limit 1`;
      const [lastuserdata] = await con.execute(lastsql);
      let check = await chech(req.body.company_uuid, "chech_count",req.body.company.master);

      if (check === true) {
        let hash = createHash('sha256').update(password).digest('hex')

        // console.log(password);
        // console.log(hash); return

        let type=req.body.company.master===1?0:req.body.role;
        let companyuuid=req.body.company.master===1?organization:req.body.company_uuid;

        let checkmaster = `SELECT * FROM users where company_uuid='${companyuuid}' and master = 0 and type = 0`;
        const [ismasterdata] = await con.execute(checkmaster);
        // console.log(ismasterdata);
        if(req.body.company.master==1 && ismasterdata.length==0){
          let deptsql = `INSERT INTO departments (name, manager,active,uuid) VALUES ('Admin',0,1,'${companyuuid}')`;
          const [deptdata] = await con.execute(deptsql);
          department = deptdata.insertId;
          hod = 0;
        }else if(req.body.company.master==1 && ismasterdata.length!=0){
          return res.status(200).json({
            status: "422",
            error: "Admin is already available",
            message: "Admin is already available",
          });
        }
        // ${req.body.company.master}
        let useruuid = uuidv4();
        let sql = `INSERT INTO users (name, uuid, company_uuid, username, contact_no, email, password, active,type, department, master) VALUES ('${name}','${useruuid}','${
          companyuuid}','${ Number(lastuserdata[0].username) + Number(1)}','${contactno}','${email}', '${hash}','${status}',${hod},${department},0)`;

       let [data] = await con.execute(sql);        

        if (data) {
          return res.status(201).json({
            status: 201,
            message: "Employee added successfully",
          });
        } else {
          return res.status(200).json({
            status: "422",
            error: "Failed to Insert",
            message: "Failed to Insert",
          });
        }
      } else {
        return res.status(200).json({
          status: "422",
          error: "Maximun limit reached",
          message: "Maximun limit reached",
        });
      }
    }
  } catch (err) {
    
    console.log(err);
    res.status(500).json({
      error: err,
    });
  }
});

router.delete("/delete-org/:id", authenticate, async (req, res) => {
  let { id } = req.params;
  try {
    let sql = `delete FROM companies where uuid='${id}'`;
    const [row] = await con.execute(sql);
    if (row) {
      res.status(201).json({
        status: 201,
        msg: "Company deleted successfully",
      });
    } else {
      return res.status(200).json({
        status: "422",
        msg: "Failed to delete.",
      });
    }
  } catch (err) {
    res.status(500).json({
      error: err,
    });
  }
});

// ######################## timezone #########################
router.post("/getAllTimezones", authenticate, async (req, res) => {
  try {
    let sql = `SELECT * from timezone`;
    const [row] = await con.execute(sql);
    if (row.length > 0) {
      res.status(201).json({
        status: 201,
        data: row,
      });
    } else {
      return res.status(200).json({
        status: "422",
        error: "No data available.",
      });
    }
  } catch (err) {
    res.status(500).json({
      error: err,
    });
  }
});

//############################ shift ###########################

router.post("/add-shift", authenticate, async (req, res) => {
  let {
    id,
    title,
    working_hrs,
    breaks,
    max_punchin_time,
    timezone,
    is_screenshot_enabled,
    screenshot_interval,
    productivity_enabled,
    is_auto_punch_out,
    auto_punch_out_time,
    is_att_regularization,
    att_regularization_limit,
    status,
  } = req.body.data;

  let company_uuid = req.body.company_uuid;
  if (status == true) {
    status = 1;
  } else {
    status = 0;
  }
  if (is_screenshot_enabled == true) {
    is_screenshot_enabled = 1;
  } else {
    is_screenshot_enabled = 0;
  }
  if (productivity_enabled == true) {
    productivity_enabled = 1;
  } else {
    productivity_enabled = 0;
  }
  if (is_att_regularization == true) {
    is_att_regularization = 1;
  } else {
    is_att_regularization = 0;
  }
  if (is_auto_punch_out == true) {
    is_auto_punch_out = 1;
  } else {
    is_auto_punch_out = 0;
  }
  try {
    let availsql = `SELECT * FROM user_shifts where title = '${title}' and  company_uuid = '${company_uuid}'`;
    let sql;
    const [availdata] = await con.execute(availsql);
    let msg;
    if (id != undefined || availdata.length > 0) {
      sql = `update user_shifts set title='${title}', working_hrs='${working_hrs}', breaks='${breaks}', max_punchin_time='${max_punchin_time}', timezone='${timezone}', is_screenshot_enabled='${is_screenshot_enabled}', screenshot_interval='${screenshot_interval}', productivity_enabled='${productivity_enabled}', is_auto_punch_out='${is_auto_punch_out}', auto_punch_out_time='${auto_punch_out_time}', is_att_regularization='${is_att_regularization}', att_regularization_limit='${att_regularization_limit}', active=${status} where shift_id = '${id}'`;
      msg = "Update";
    } else {
      let created_at = moment(new Date()).format("YYYY-MM-DD HH:MM:SS");

      sql = `INSERT INTO user_shifts (company_uuid, title, working_hrs, breaks, max_punchin_time, timezone, is_screenshot_enabled, screenshot_interval,productivity_enabled, is_auto_punch_out, auto_punch_out_time, is_att_regularization, att_regularization_limit, created_at, active) VALUES ('${company_uuid}','${title}','${working_hrs}','${breaks}','${max_punchin_time}','${timezone}','${is_screenshot_enabled}', '${screenshot_interval}', '${productivity_enabled}', '${is_auto_punch_out}', '${auto_punch_out_time}', '${is_att_regularization}', '${att_regularization_limit}', '${created_at}' , '${status}')`;
      msg = "Insert";
    }

    const [data] = await con.execute(sql);
    if (data) {
      res.status(201).json({
        status: 201,
        message: msg + " success",
      });
    } else {
      return res.status(200).json({
        status: "422",
        error: "Failed to Insert",
      });
    }
  } catch (err) {
    res.status(500).json({
      error: err,
    });
  }
});

router.post("/getShiftData", authenticate, async (req, res) => {
  try {
    let sql = `SELECT * from user_shifts where company_uuid='${req.body.uuid}'`;
    const [row] = await con.execute(sql);

    if (row.length > 0) {
      res.status(201).json({
        status: 201,
        data: row,
      });
    } else {
      return res.status(200).json({
        status: "422",
        error: "No data available.",
      });
    }
  } catch (err) {
    res.status(500).json({
      error: err,
    });
  }
});

//############################ change-productive-status ###########################

router.post("/change-productive-status", authenticate, async (req, res) => {
  let { status, id } = req.body;
  try {
    let sql = `update activewin_icons set is_productive='${status}' where id = '${id}'`;
    const [row] = await con.execute(sql);
    if (row) {
      res.status(201).json({
        status: 201,
        msg: "Record updated successfully",
      });
    } else {
      return res.status(200).json({
        status: "422",
        msg: "Failed to update.",
      });
    }
  } catch (err) {
    res.status(500).json({
      error: err,
    });
  }
});

//############################ notification ###########################
router.post("/save-notification", authenticate, async (req, res) => {
  let { id, title, description } = req.body.data;
  let company_uuid = req.body.company_uuid;
  try {
    let msg;
    if (id != undefined && id != "") {
      sql = `update notification set title='${title}', description='${description}' where notification_id  = '${id}'`;
      msg = "Update";
    } else {
      let created_at = moment(new Date()).format("YYYY-MM-DD HH:MM:SS");
      sql = `INSERT INTO notification (company_uuid, user_id, displaynotificationuserid, title, description,created_at) VALUES ('${company_uuid}', 0,0, '${title}','${description}','${created_at}')`;
      msg = "Insert";
    }
    const [data] = await con.execute(sql);
    if (data) {
      res.status(201).json({
        status: 201,
        message: msg + " success",
      });
    } else {
      return res.status(200).json({
        status: "422",
        error: "Failed to Process",
      });
    }
  } catch (err) {
    console.log(err);
    res.status(500).json({
      error: err,
    });
  }
});

router.post("/getAllNotifications", authenticate, async (req, res) => {
  let { company_uuid } = req.body;
  try {
    let sql = `SELECT * from notification where company_uuid = '${company_uuid}' or company_uuid = '' and user_id=0 order by notification_id desc`;
    const [row] = await con.execute(sql);
    if (row.length > 0) {
      res.status(201).json({
        status: 201,
        data: row,
      });
    } else {
      return res.status(200).json({
        status: "422",
        error: "No data available.",
      });
    }
  } catch (err) {
    res.status(500).json({
      error: err,
    });
  }
});

router.post("/delete-notification", authenticate, async (req, res) => {
  let { id } = req.body;
  try {
    let sql = `delete FROM notification where notification_id=${id}`;
    const [row] = await con.execute(sql);
    if (row) {
      res.status(201).json({
        status: 201,
        msg: "Record deleted successfully",
      });
    } else {
      return res.status(200).json({
        status: "422",
        msg: "Failed to delete.",
      });
    }
  } catch (err) {
    res.status(500).json({
      error: err,
    });
  }
});

//############################ org detail  ###########################

router.post("/getAllOrgdetails", authenticate, async (req, res) => {
  let { company_uuid } = req.body;
  try {
    let sql = `SELECT * from companies where uuid='${company_uuid}'`;
    const [row] = await con.execute(sql);
    if (row.length > 0) {
      res.status(201).json({
        status: 201,
        data: row,
      });
    } else {
      return res.status(200).json({
        status: "422",
        error: "No data available.",
      });
    }
  } catch (err) {
    res.status(500).json({
      error: err,
    });
  }
});

//############################ holiday ###########################

router.post("/getAllHolidays", authenticate, async (req, res) => {
  try {
    let sql = `SELECT * from holidays where YEAR(date) = YEAR(CURDATE()) and uuid='${req.body.uuid}' order by date desc`;

    const [row] = await con.execute(sql);
    if (row.length > 0) {
      res.status(201).json({
        status: 201,
        data: row,
      });
    } else {
      return res.status(200).json({
        status: "200",
        error: "No data available.",
      });
    }
  } catch (err) {
    res.status(500).json({
      error: err,
    });
  }
});

router.post("/save-holiday", authenticate, async (req, res) => {
  let { id, date, name } = req.body.data;
  try {
    let msg;
    if (id != undefined && id != "") {
      sql = `update holidays set date='${date}', name='${name}' where holiday_id  = '${id}'`;
      msg = "Update";
    } else {
      let created_at = moment(new Date()).format("YYYY-MM-DD HH:MM:SS");
      sql = `INSERT INTO holidays (date, name, created_at,uuid) VALUES ('${date}', '${name}','${created_at}','${req.body.uuid}')`;
      msg = "Insert";
    }
    const [data] = await con.execute(sql);
    if (data) {
      res.status(201).json({
        status: 201,
        message: msg + " success",
      });
    } else {
      return res.status(200).json({
        status: "422",
        error: "Failed to Process",
      });
    }
  } catch (err) {
    res.status(500).json({
      error: err,
    });
  }
});

router.post("/delete-holiday", authenticate, async (req, res) => {
  let { id } = req.body;
  try {
    let sql = `delete FROM holidays where holiday_id=${id}`;
    const [row] = await con.execute(sql);
    if (row) {
      res.status(201).json({
        status: 201,
        msg: "Record deleted successfully",
      });
    } else {
      return res.status(200).json({
        status: "422",
        msg: "Failed to delete.",
      });
    }
  } catch (err) {
    res.status(500).json({
      error: err,
    });
  }
});

//############################ alert ###########################

router.post("/getAllAlerts", authenticate, async (req, res) => {
  let company_uuid = req.body.company_uuid;
  try {
    let sql = `SELECT * from alerts where company_uuid = '${company_uuid}'`;
    const [row] = await con.execute(sql);
    if (row.length > 0) {
      res.status(201).json({
        status: 201,
        data: row,
      });
    } else {
      return res.status(200).json({
        status: "422",
        error: "No data available.",
      });
    }
  } catch (err) {
    res.status(500).json({
      error: err,
    });
  }
});

router.post("/save-alertdata", authenticate, async (req, res) => {
  let { id, is_enable, for_manager, max_alert, alert_interval, alert_repeat } =
    req.body.data;

  let company_uuid = req.body.company_uuid;
  if (is_enable == true) {
    is_enable = 1;
  } else {
    is_enable = 0;
  }
  if (for_manager == true) {
    for_manager = 1;
  } else {
    for_manager = 0;
  }

  try {
    let msg;
    if (id != undefined) {
      sql = `update alerts set is_enable='${is_enable}', for_manager='${for_manager}', max_alert='${max_alert}', alert_interval='${alert_interval}', alert_repeat='${alert_repeat}' where id = '${id}' and company_uuid = '${company_uuid}'`;
      msg = "Update";
    }
    const [data] = await con.execute(sql);
    if (data) {
      res.status(201).json({
        status: 201,
        message: msg + " success",
      });
    } else {
      return res.status(200).json({
        status: "422",
        error: "Failed to Save",
      });
    }
  } catch (err) {
    res.status(500).json({
      error: err,
    });
  }
});

//############################ leave  ###########################

router.post("/getAllLeavetypes", authenticate, async (req, res) => {
  let company_uuid = req.body.company_uuid;

  try {
    let sql = `SELECT * from leavetype where uuid = '${company_uuid}'`;
    const [row] = await con.execute(sql);

    if (row.length > 0) {
      res.status(201).json({
        status: 201,
        data: row,
      });
    } else {
      return res.status(200).json({
        status: "422",
        error: "No data available.",
      });
    }
  } catch (err) {
    res.status(500).json({
      error: err,
    });
  }
});

router.post("/save-leavetype", authenticate, async (req, res) => {
  let { id, name, description, no, status } = req.body.data;
  let company_uuid = req.body.company_uuid;
  if (status == true) {
    status = 1;
  } else {
    status = 0;
  }
  try {
    let sql;
    let altsql;
    let msg;
    if (id != undefined) {
      let availsql = `SELECT * FROM leavetype where name = '${id}' and company_uuid='${company_uuid}'`;
      const [availdata] = await con.execute(availsql);

      sql = `update leavetype set name='${name}', description='${description}', no='${no}', status='${status}' where type_id = '${id}' and company_uuid = '${company_uuid}'`;
      msg = "Update";
    } else {
      sql = `INSERT INTO leavetype (uuid, name, description, no, status) VALUES ('${company_uuid}', '${name}','${description}','${no}','${status}')`;
      msg = "Insert";

      altsql = `ALTER TABLE user_leaves ADD COLUMN ${name} VARCHAR(100) DEFAULT ${no}`;
    }
    const [data] = await con.execute(sql);
    if (altsql) {
      const [altdata] = await con.execute(altsql);
    }

    if (data) {
      res.status(201).json({
        status: 201,
        message: msg + " success",
      });
    } else {
      return res.status(200).json({
        status: "422",
        error: "Failed to Save",
      });
    }
  } catch (err) {
    res.status(500).json({
      error: err,
    });
  }
});

router.post("/delete-leavetype", authenticate, async (req, res) => {
  let { id } = req.body;
  try {
    let availsql = `SELECT * FROM leavetype where type_id = '${id}'`;
    const [availdata] = await con.execute(availsql);

    let sql1 = `ALTER TABLE user_leaves DROP COLUMN ${availdata[0]["name"]}`;
    const [row1] = await con.execute(sql1);

    let sql = `delete FROM leavetype where type_id=${id}`;
    const [row] = await con.execute(sql);

    if (row && row1) {
      res.status(201).json({
        status: 201,
        msg: "Record deleted successfully",
      });
    } else {
      return res.status(200).json({
        status: "422",
        msg: "Failed to delete.",
      });
    }
  } catch (err) {
    res.status(500).json({
      error: err,
    });
  }
});

//############################ acc setting ###########################

router.post("/getAccountSetting", authenticate, async (req, res) => {
  let company_uuid = req.body.company_uuid;
  try {
    let sql = `SELECT * from account_settings where company_uuid = '${company_uuid}'`;
    const [row] = await con.execute(sql);
    if (row.length > 0) {
      res.status(201).json({
        status: 201,
        data: row,
      });
    } else {
      return res.status(200).json({
        status: "422",
        error: "No data available.",
      });
    }
  } catch (err) {
    res.status(500).json({
      error: err,
    });
  }
});

router.post("/add-accsettings", authenticate, async (req, res) => {
  let { id, timezone, daily_act_report, clear_att } = req.body.data;
  let company_uuid = req.body.company_uuid;
  if (daily_act_report == true) {
    daily_act_report = 1;
  } else {
    daily_act_report = 0;
  }
  if (clear_att == true) {
    clear_att = 1;
  } else {
    clear_att = 0;
  }
  try {
    let availsql = `SELECT * FROM account_settings where company_uuid = '${company_uuid}'`;
    const [availdata] = await con.execute(availsql);
    let msg;
    if (availdata.length > 0) {
      sql = `update account_settings set timezone='${timezone}', daily_act_report='${daily_act_report}', clear_att='${clear_att}' where company_uuid = '${company_uuid}'`;
      msg = "Update";
    } else {
      sql = `INSERT INTO account_settings (company_uuid, timezone, daily_act_report, clear_att) VALUES ('${company_uuid}', '${timezone}','${daily_act_report}','${clear_att}')`;
      msg = "Insert";
    }
    const [data] = await con.execute(sql);
    if (data) {
      res.status(201).json({
        status: 201,
        message: msg + " success",
      });
    } else {
      return res.status(200).json({
        status: "422",
        error: "Failed to Process",
      });
    }
  } catch (err) {
    res.status(500).json({
      error: err,
    });
  }
});

// Positions
router.post("/getAllPositions", async (req, res) => {
  let { company_uuid,username } = req.body;
  try {
    let sql;
    // if(username=='1009'){
    //   sql = `SELECT * from positions where company_uuid='${company_uuid}' and name like "%SEO%"`;
    // }else if(username=='1033'){
    //   sql = `SELECT * from positions where company_uuid='${company_uuid}' and name like "%Developer%"`;
    // }else{
      sql = `SELECT * from positions where company_uuid='${company_uuid}'`;
    // }
    const [row] = await con.execute(sql);
    
    let jobappsql = `SELECT is_jobapplication_next_form_avail from user_shifts where company_uuid='${company_uuid}'`;
    const [jobapprow] = await con.execute(jobappsql);
   
    if (row.length > 0) {
      let newarr = [];
      for (let index = 0; index < row.length; index++) {
        const element = row[index];
          let sql = `SELECT questions_data from job_questions where position_id='${element.uuid}'`;
          const [querow] = await con.execute(sql);
          if(querow.length>0){
            element.isaddedque = 1
          }else{
            element.isaddedque = 0
          }
          newarr.push(element)
      }
      res.status(201).json({
        status: 201,
        data: newarr,
        jobappdata: jobapprow && jobapprow[0]
      });
    } else {
      return res.status(200).json({
        status: "422",
        error: "No data available.",
      });
    }
  } catch (err) {
    res.status(500).json({
      error: err,
    });
  }
});


router.post("/save-position", authenticate, async (req, res) => {
  let { id, title, description } = req.body.data;
  // console.log( id, title, description);return
  let company_uuid = req.body.company_uuid;
  try {
    let msg;
    if (id != undefined && id != "") {
      sql = `update positions set name='${title}', descriptions='${description}' where id='${id}'`;
      msg = "Update";
    } else {
      let created_at = moment(new Date()).format("YYYY-MM-DD HH:MM:SS");
      let uuid = uuidv4();
      sql = `INSERT INTO positions (uuid,company_uuid, name, descriptions) VALUES ('${uuid}','${company_uuid}','${title}','${description}')`;
      msg = "Insert";
    }
    const [data] = await con.execute(sql);
    if (data) {
      res.status(201).json({
        status: 201,
        message: msg + " success",
      });
    } else {
      return res.status(200).json({
        status: "422",
        error: "Failed to Process",
      });
    }
  } catch (err) {
    console.log(err);
    res.status(500).json({
      error: err,
    });
  }
});


router.post("/delete-position", authenticate, async (req, res) => {
  let { uuid } = req.body;
  try {
    let sql = `delete FROM positions where uuid='${uuid}'`;
    const [row] = await con.execute(sql);
    if (row) {
      res.status(201).json({
        status: 201,
        msg: "Record deleted successfully",
      });
    } else {
      return res.status(200).json({
        status: "422",
        msg: "Failed to delete.",
      });
    }
  } catch (err) {
    res.status(500).json({
      error: err,
    });
  }
});

router.post("/get-positionquestions", authenticate, async (req, res) => {
  let { uuid } = req.body;
  // console.log(uuid);return
  try {
    let positionsql = `SELECT * from positions where uuid='${uuid}'`;
    let sql = `SELECT questions_data from job_questions where position_id='${uuid}'`;
    const [row] = await con.execute(sql);
    const [positionsqlrow] = await con.execute(positionsql);
    if (row.length > 0 || positionsqlrow.length > 0) {
      res.status(201).json({
        status: 201,
        data: row,
        positondata: positionsqlrow,
      });
    } else {
      return res.status(200).json({
        status: "422",
        error: "No data available.",
      });
    }
  } catch (err) {
    res.status(500).json({
      error: err,
    });
  }
});

router.post("/admin-getAllUsers", authenticate, async (req, res) => {

  const { role,department, listtype, usertype, type, master } = req.body;
  // console.log("role");
  try {
    // console.log(role);
    // let alluser = [];
    // if(role !== 1){
      let sql2;
      let date2 = moment(new Date()).format("YYYY-MM-DD");
      // let uuidsql = `select username from users where company_uuid='${req.body.uuid}'`;
      // const [att] = await con.execute(uuidsql);

      // for (let i = 0; i < att.length; i++) {
      //   const element = att[i];
      if(usertype==1){
        sql2 = `SELECT * FROM attendance_jenyatracking WHERE date='${date2}' and company_uuid='${req.body.uuid}' and department='${department}'`;
      }else{
        sql2 = `SELECT * FROM attendance_jenyatracking WHERE date='${date2}' and company_uuid='${req.body.uuid}'`;
      }
        // username=${element.username} and 
        const [alluser] = await con.execute(sql2);
        // console.log(alluser);
    //     if (attdata2[0] != undefined) {
    //       alluser.push(attdata2[0]);
    //     }
    //   }
    // }
  
    
    let sql;
    if (type == undefined) {
      if(master == 1){
        sql = `SELECT users.*, companies.uuid as companyuuid, companies.name as companyname FROM users LEFT JOIN companies ON companies.uuid = users.company_uuid where users.active = 1 and users.type = 0 order by users.user_id desc`;
        // users.master = 0 and
        // console.log(sql);
      }else{
        if(listtype==1){
          sql = `SELECT users.*, departments.name as deptname FROM users LEFT JOIN departments ON departments.department_id = users.department where users.active = 1 and users.company_uuid='${req.body.uuid}' order by users.user_id desc`;
        }else{
          sql = `SELECT users.*, departments.name as deptname FROM users LEFT JOIN departments ON departments.department_id = users.department where users.active = 1 and departments.uuid='${req.body.uuid}' order by users.user_id desc`;
        }
      }
      // console.log(sql);
    } else {
      if(master == 1){
        sql = `select * from users where company_uuid='${req.body.uuid}' and master = 0 and type = 0 and active = 1 order by user_id desc`;
      }else{
        if(usertype==1){
          sql = `select * from users where company_uuid='${req.body.uuid}' and department='${req.body.department}' and active = 1 order by user_id desc`;
        }else{
          sql = `select * from users where company_uuid='${req.body.uuid}' and active = 1 order by user_id desc`;
        }
        // console.log(sql);
      }
    }
    
    // let sql = `select * from users where company_uuid='${req.body.uuid}' and active=1 `;
    // console.log(sql);
    const [row] = await con.execute(sql);
// console.log(row);
    // const [row2] = await con.execute(sql2);

    if (row.length > 0) {
      res.status(201).json({
        status: 201,
        data: row,
        alluser: alluser,
      });
    } else {
      return res.status(200).json({
        status: "422",
        error: "No data available.",
      });
    }
  } catch (err) {
    console.log(err);
    res.status(500).json({
      error: err,
    });
  }
});


// Project Module

router.post("/get-projects", authenticate, async (req, res) => {

  const { role,department, listtype, usertype, type, master } = req.body;
  try {
      let sql2 = `SELECT * FROM projects WHERE department='${department}' order by project_id desc`;
      // console.log(sql2);
    const [alluser] = await con.execute(sql2);
    // const [row] = await con.execute(sql);

    if (alluser.length > 0) {
      res.status(201).json({
        status: 201,
        // data: row,
        projects: alluser,
      });
    } else {
      return res.status(200).json({
        status: "422",
        error: "No data available.",
      });
    }
  } catch (err) {
    console.log(err);
    res.status(500).json({
      error: err,
    });
  }
});


router.delete("/delete-project/:id", authenticate, async (req, res) => {
  let { id } = req.params;
  try {
    let sql = `delete FROM projects where project_id=${id}`;
    // console.log(sql);
    const [row] = await con.execute(sql);
    if (row) {
      res.status(201).json({
        status: 201,
        msg: "Record deleted successfully",
      });
    } else {
      return res.status(200).json({
        status: "422",
        msg: "Failed to delete.",
      });
    }
  } catch (err) {
    res.status(500).json({
      error: err,
    });
  }
});


router.post("/add-project", authenticate, async (req, res) => {
  let { id, name ,department,status } = req.body.data;
  status  = status?1:0;
  // console.log(status); return
  // console.log(req.body.company.id); return
  try {
    // let availsql = `SELECT * FROM projects where name = '${name}' and department='${department}'`;
    // const [availdata] = await con.execute(availsql);
    // let msg;
    if(id!=""){
      sql = `update projects set name='${name}', status='${status}' where project_id = '${id}'`;
      msg = "Update";
    } else {
      let created_at = moment(new Date()).format("YYYY-MM-DD HH:MM:SS");
      sql = `INSERT INTO projects (user_id, name, department, status,created_at,updated_at) VALUES ('${req.body.company.id}', '${name}','${department}','${status}','${created_at}','${created_at}')`;
      msg = "Insert";
    }
    // console.log(sql);
    const [data] = await con.execute(sql);
    if (data) {
      res.status(201).json({
        status: 201,
        message: msg + " success",
      });
    } else {
      return res.status(200).json({
        status: "422",
        error: "Failed to Process",
      });
    }
  } catch (err) {
    // console.log(err);
    res.status(500).json({
      error: err,
    });
  }
});


router.delete("/delete-activity/:id", authenticate, async (req, res) => {
  let { id } = req.params;
  try {
    let sql = `delete FROM project_activity where activity_id =${id}`;
    // console.log(sql);
    const [row] = await con.execute(sql);
    if (row) {
      res.status(201).json({
        status: 201,
        msg: "Record deleted successfully",
      });
    } else {
      return res.status(200).json({
        status: "422",
        msg: "Failed to delete.",
      });
    }
  } catch (err) {
    res.status(500).json({
      error: err,
    });
  }
});



router.post("/add-activity", authenticate, async (req, res) => {
  let { proj_id, id, name ,status,billable } = req.body.data;
  status  = status?1:0;
  // billable  = billable?1:0;
  try {
    if(id!=""){
      sql = `update project_activity set activity_name='${name}', billable='${billable}', status='${status}' where activity_id  = '${id}'`;
      msg = "Update";
    } else {
      let created_at = moment(new Date()).format("YYYY-MM-DD HH:MM:SS");
      sql = `INSERT INTO project_activity (project_id, activity_name, billable,status,created_at) VALUES ('${proj_id}', '${name}','${billable}','${status}','${created_at}')`;
      msg = "Insert";
    }
    // console.log(sql);
    const [data] = await con.execute(sql);
    if (data) {
      res.status(201).json({
        status: 201,
        message: msg + " success",
      });
    } else {
      return res.status(200).json({
        status: "422",
        error: "Failed to Process",
      });
    }
  } catch (err) {
    console.log(err);
    res.status(500).json({
      error: err,
    });
  }
});

router.post("/interview_status/:uuid/:status", authenticate, async (req, res) => {
  let { uuid, status } = req.params;
  try {
    let sql = `update applications set interviewStatus='${status}', comment='${req.body.comment}' where uuid ='${uuid}'`;
    // console.log(sql);
    const [row] = await con.execute(sql);
    if (row) {
      res.status(201).json({
        status: 201,
        msg: "Record updated successfully",
      });
    } else {
      return res.status(200).json({
        status: "422",
        msg: "Failed to update.",
      });
    }
  } catch (err) {
    res.status(500).json({
      error: err,
    });
  }
});


//********************************Add Employee Ticket******************************************** /

router.post("/add-emp-ticket", async (req, res) => {
	
  try {
  const { username } = req.body;
      const {	
    date,
    punch_start_time,	
    punch_end_time,	
    lunch_start_time,
    lunch_end_time,
    reason,
    status,  
      } = req.body.data;
  var created_at = moment(new Date()).format("YYYY-MM-DD HH:MM:SS");
  var tdate = moment(new Date(date)).format("YYYY-MM-DD");
// console.log(created_at);

      const query =	
          "INSERT INTO employee_ticket (username, created_at, date, punch_start_time, punch_end_time, lunch_start_time, lunch_end_time, reason, status) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
      await con.query(query, [
    username,
    created_at,	
    tdate,	
    punch_start_time,
    punch_end_time,
    lunch_start_time,
    lunch_end_time,
    reason,
    status,  
      ]);
  // console.log(username,
  //   created_at,	
  //   date,	
  //   punch_start_time,
  //   punch_end_time,
  //   lunch_start_time,
  //   lunch_end_time,
  //   reason,
  //   status,  );

      res.status(201).json({
          message: "Leave request inserted successfully",
    date,
    punch_start_time,
    punch_end_time,
    lunch_start_time,
    lunch_end_time,
    reason,
    status,  
      });
  } catch (error) {
      console.error("Error inserting data into MySQL: ", error);
      res.status(500).json({ error: "Error inserting data into MySQL" });
  }
});

router.post("/show-emp-ticket", async (req, res) => {	
const{username, role} = req.body;
// console.log(username, role);

try {
  let query
  if(role == 0){
   query = "SELECT * FROM employee_ticket  ORDER BY id DESC";
  }
  else{
     query = `SELECT * FROM employee_ticket WHERE username ='${username}' ORDER BY id DESC`;
      }
  console.log(query);
  const [data] = await con.query(query);
  // res.json(rows);
  res.status(200).json({ data });

  
  
  
} catch (error) {	
  console.error("Error fetching data from MySQL: ", error);
  res.status(500).json({ error: "Error fetching data from MySQL" });
}
});


router.delete("/delete-emp-ticket/:id", async (req, res) => {
const id = req.params.id;

console.log(id)
try {
  const deleteSql = `DELETE FROM employee_ticket WHERE id = ?`; 
  const [result] = await con.execute(deleteSql, [id]); 
  if (result.affectedRows === 1) {
    res.status(200).json({
      status: 200,
      message: "User deleted successfully",
    });
  } else {
    res.status(404).json({ status: 404, error: "User not found" });
  }
} catch (err) {
  console.error(err);
  res.status(500).json({ status: 500, error: "Internal server error" });
}
});

router.put("/update-emp-ticket/:id", async (req, res) => {
const id = req.params.id;
const NewTicket = req.body; 
// console.log(NewPoints)	
try {

  const updateSql = `UPDATE employee_ticket SET date = ?, punch_start_time = ?,
  punch_end_time = ?, lunch_start_time = ?, lunch_end_time = ?, reason = ?, status WHERE id = ${id}`;
  const [result] = await con.execute(updateSql, [
  NewTicket.date,
  NewTicket.punch_start_time,
  NewTicket.punch_end_time,
  NewTicket.lunch_start_time,	
  NewTicket.lunch_end_time,
  NewTicket.reason,
  NewTicket.status
  ]);

// console.log("new updating data points",result)
  if (result.affectedRows === 1) {
  res.status(200).json({
    status: 200,
    message: "Employee points updated successfully",
  });
  } else {
  res.status(404).json({ status: 404, error: "Employee not found" });
  }
} catch (error) {
  console.error(error);
  res.status(500).json({ status: 500, error: "Internal server error" });
}
});

// *******************************************************************************************************


//********************************************AdminTicket************************************************ /

router.put('/admin-update-ticket/:id', async (req, res) => {
	const id = req.params.id;
	const { action } = req.body;
		console.log("admon action",action);
	try {
	  let newStatus;
	  if (action === 'accept') {
		newStatus = 1; // Accepted
	  } else if (action === 'reject') {
		newStatus = 2; // Rejected
	  } else {
		throw new Error('Invalid action');
	  }
	  const updateSql = 'UPDATE employee_ticket SET status = ? WHERE id = ?';
	  const [result] = await con.execute(updateSql, [newStatus, id]);
  
	  if (result.affectedRows === 1) {
		res.status(200).json({ message: `Ticket ${action}ed successfully` });
	  } else {
		res.status(404).json({ error: 'Ticket not found' });
	  }
	} catch (error) {
	  console.error(`Error ${action}ing ticket:`, error);
	  res.status(500).json({ error: 'Internal server error' });
	}
  });


  router.post("/add-attendance", async (req, res) => {
    try {
        const {	
			username,
			date,
			punch_start_time,	
			punch_end_time,	
			lunch_start_time,
			lunch_end_time	  
        } = req.body.AccepTicket;
        
       var tdate = moment(new Date(date)).format("YYYY-MM-DD");
        const existingRecord = await con.query("SELECT * FROM attendance WHERE user_id = ? AND date = ?", [username, tdate]);
        // console.log(existingRecord);
        // console.log(username);
        // console.log(tdate);
        if (existingRecord.length > 0) { 
            const updateQuery =
                "UPDATE attendance SET job_in_time = ?, job_out_time = ?, lunch_in_time = ?, lunch_out_time = ? WHERE user_id = ? AND date = ?";
            await con.query(updateQuery, [
                punch_start_time,
                punch_end_time,
                lunch_start_time,
                lunch_end_time,
                username,
                tdate
            ]);
          
            res.status(200).json({
                message: "Attendance record updated successfully",
                username,
                tdate,
                punch_start_time,
                punch_end_time,
                lunch_start_time,
                lunch_end_time
            });
        } else {
            // If the record doesn't exist, insert it
            const insertQuery =
                "INSERT INTO attendance (user_id, date, job_in_time, job_out_time, lunch_in_time, lunch_out_time) VALUES (?, ?, ?, ?, ?, ?)";
            await con.query(insertQuery, [
                username,
                tdate,
                punch_start_time,
                punch_end_time,
                lunch_start_time,
                lunch_end_time
            ]);
            // console.log("Record inserted:", username, date);
            res.status(201).json({
                message: "Attendance record inserted successfully",
                username,
                date,
                punch_start_time,
                punch_end_time,
                lunch_start_time,
                lunch_end_time
            });
        }
    } catch (error) {
        console.error("Error inserting/updating data into MySQL: ", error);
        res.status(500).json({ error: "Error inserting/updating data into MySQL" });
    }
});


router.post("/leave-requests", async (req, res) => {
    try {
        const {
            user_id,
			uuid,
			department,
			company_uuid,
            leaveday,
            reason,
            day,
            halfDayType,
            startDate,
            endDate,
            noofdays,
            request_date,
        } = req.body;

        const query =
            "INSERT INTO leave_requests_new (user_id, uuid, department, company_uuid, leaveday, reason, day, halfdaytype, start_date, end_date, noofdays, request_date) VALUES ( ? ,? , ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";

        // Execute the query with the provided data
        await con.query(query, [
            user_id,
			uuid,
			department,
			company_uuid,
            leaveday,
            reason,
            day,
            halfDayType,
            startDate,
            endDate,
            noofdays,
            request_date,
        ]);

        res.status(201).json({
            message: "Leave request inserted successfully",
            user_id,
			uuid,
			department,
			company_uuid,
            leaveday,
            day,
            halfDayType,
            startDate,
            endDate,
            noofdays,
            reason,
            request_date,
        });
    } catch (error) {
        console.error("Error inserting data into MySQL: ", error);
        res.status(500).json({ error: "Error inserting data into MySQL" });
    }
});



module.exports = router;
