const dotenv = require("dotenv");
const express = require("express");
const compression = require("compression");

const cors = require("cors");
const app = express();
app.use(cors());

dotenv.config({ path: "./config.env" });
require("./db/conn");

app.use(
  compression({
    level: 6,
    threshold: 100 * 1000,
    filter: (req, res) => {
      if (req.header["x-no-compression"]) {
        return false;
      }
      return compression.filter(req, res);
    },
  })
);

app.use(express.json());
app.use(express.urlencoded({ extended: true }));

app.use(require("./controller/crm"));
app.use(require("./controller/job"));
app.use(require("./controller/auth"));
app.use(require("./controller/insight"));
app.use(require("./controller/home"));
app.use(require("./controller/dashboard"));
app.use(require("./controller/report"));
app.use(require("./controller/admin"));
app.use(require("./controller/cron"));
app.use(require("./controller/client"));
// app.use(require("./controller/socketio"));

const PORT = 5000; //||process.env.PORT;

app.use("/uploads", express.static("uploads"));

app.listen(PORT, () => {
  console.log(`${PORT} running`);
});
