from datetime import datetime, timedelta
from functools import lru_cache
from bson import ObjectId

def convert_objectid_pr(data):
    if isinstance(data, list):
        return [convert_objectid_pr(item) for item in data]
    elif isinstance(data, dict):
        return {key: convert_objectid_pr(value) for key, value in data.items()}
    elif isinstance(data, ObjectId):
        return str(data)
    else:
        return data
