import smtplib
from datetime import date
from email import encoders
from email.mime.base import MIMEBase
from email.mime.multipart import MIMEMultipart
from email.mime.text import MIMEText

def email_sender() -> str:
    current_date = date.today()
    filenames = [
        f"/var/www/html/trade_iq/db_updater/daily_files/NSE_UPDATED_{current_date}.csv",  # Example file 1
        f"/var/www/html/trade_iq/db_updater/daily_files/BSE_UPDATED_{current_date}.csv",  # Example file 2
    ]
    
    port = 587
    smtp_server = "smtp.gmail.com"
    login = "bhavik.patel@rayvat.com"  # Your login
    password = "*LKJ4%tmR}"  # Your password

    subject = f'Daily NSE BSE Data for {current_date}'
    sender_email = "bhavik.patel@rayvat.com"
    receiver_email = "stocks.rayvat@gmail.com"
    CC = "bhavik.patel@rayvat.com"

    message = MIMEMultipart()
    message["From"] = sender_email
    message["To"] = receiver_email
    message["Subject"] = subject
    message["CC"] = CC

    # Add body to email
    body = f'NSE BSE Data is being scraped date: {current_date}'
    message.attach(MIMEText(body, "plain"))

    # Attach multiple files
    for filename in filenames:
        with open(filename, "rb") as attachment:
            part = MIMEBase("application", "octet-stream")
            part.set_payload(attachment.read())
        
        encoders.encode_base64(part)
        part.add_header(
            "Content-Disposition",
            f"attachment; filename= {filename}",
        )
        message.attach(part)

    text = message.as_string()

    # send your email
    with smtplib.SMTP(smtp_server, port) as server:
        server.starttls()
        server.login(login, password)
        server.sendmail(sender_email, [receiver_email, CC], text)

    print("Email sent successfully...")


if __name__ == "__main__":
    # Call the function to send the email
    email_sender()
