from typing import Union, Dict, List
from bson import ObjectId

def convert_objectid_ohlc(data: Union[Dict, List]) -> Union[Dict, List]:
    """Convert MongoDB ObjectId to string in nested structures."""
    if isinstance(data, dict):
        return {k: str(v) if isinstance(v, ObjectId) else convert_objectid_ohlc(v)
                for k, v in data.items()}
    elif isinstance(data, list):
        return [convert_objectid_ohlc(item) for item in data]
    return data