'''This code scraps data from Zerodha (Daily)'''
from z_getBSEdata import getBSEdata
import pandas as pd
import datetime
import requests
import json

from dotenv import load_dotenv
load_dotenv()

from pymongo import MongoClient
import mysql.connector as mc


def bse_get() -> None:
    '''
    This function retrieves Daily BSE Data.

    Source: kite.zerodha.com
    '''

    # Connect to MongoDB
    mongo_client = MongoClient('mongodb://192.168.31.176:27017/')
    db = mongo_client['office']
    collection = db['zerodha_bse_new']

    # Connect to MySQL
    conn = mc.connect(user='root', host='localhost', password='', database='instruments', port=3307)
    cursor = conn.cursor()

    # Get Auth
    with open("zerodha\credentials.json") as f:
        json_data = json.loads(f.read())
    enctoken = json_data["enctoken"]

    # Read the CSV file
    cursor.execute("SELECT `Symbol.1` FROM zerodha_bse_new WHERE `exchange` = 'BSE' AND `segment` = 'BSE' AND `instrument_type` = 'EQ';")
    checkSymbols = cursor.fetchall()

    # Set up headers for API request
    headers = {
    'accept': '*/*',
    'accept-language': 'en-US,en;q=0.9',
    'authorization': f'enctoken {enctoken}'
    }

    today = datetime.date.today()
    yesterday = today - datetime.timedelta(days=1)

    for symbol in checkSymbols:
        # Check if the symbol[0] exists in MongoDB
        existing_document = collection.find_one({'symbol': symbol[0]})
        
        if existing_document:
            # If exists, find the last recorded date
            try:
                last_date = max(datetime.datetime.strptime(date, '%Y-%m-%d').date() for date in existing_document['prices'].keys())
            except:
                last_date = datetime.datetime.strptime("2024-07-08", '%Y-%m-%d').date()

            from_date = last_date + datetime.timedelta(days=1)
            
            if from_date > yesterday:
                print(f"Data for {symbol[0]} is up to date.")
                continue
        else:
            # If not exists, set from_date to a default start date
            from_date = datetime.date(2019, 1, 1)
        
        print(f"Processing {symbol[0]} from {from_date} to {yesterday}")

        # Get instrument token from MySQL
        cursor.execute(f"SELECT instrument_token FROM `mytable` WHERE `Symbol.1` LIKE '{symbol[0]}' AND `instrument_type` LIKE 'EQ' AND `exchange` LIKE 'BSE' ORDER BY `instrument_type` DESC")
        token = cursor.fetchone()
        
        if token is not None:
            instToken = token[0]
            url = f"https://kite.zerodha.com/oms/instruments/historical/{instToken}/day?user_id=GMG829&oi=0&from={from_date}&to={yesterday}"
            response = json.loads(requests.request("GET", url, headers=headers, data={}).text)

            print(response)
        
            try:
                if response and response['data']['candles']:
                    new_prices = {}
                    for candle in response['data']['candles']:
                        candle_date = datetime.datetime.strptime(candle[0].split('T')[0], '%Y-%m-%d').date()
                        new_prices[candle_date.strftime('%Y-%m-%d')] = candle[4]
                    
                    if existing_document:
                        # Update existing document
                        existing_document['prices'].update(new_prices)
                        existing_document['timestamp'] = datetime.datetime.now()
                        collection.replace_one({'symbol': symbol[0]}, existing_document)
                    else:
                        # Insert new document
                        new_document = {
                            'symbol': symbol[0],
                            'timestamp': datetime.datetime.now(),
                            'prices': new_prices
                        }
                        collection.insert_one(new_document)
                    
                    print(f"Completed processing {symbol[0]}")
                else:
                    print(f"No new data available for {symbol[0]}.")
            except Exception as e:
                print("Got Exception Error as ", e)
        else:
            print(f"No instrument token found for {symbol[0]}")

    print("Processing completed. Results saved to MongoDB")
    mongo_client.close()
    conn.close()

    # Download Retrieved BSE Data
    getBSEdata()

if __name__ == "__main__":
    bse_get()