'''
Example on how to implement connection for zerodha
'''

import logging
from zerodha_ticker import KiteTicker

kws = KiteTicker()

logging.basicConfig(level=logging.DEBUG)

def on_ticks(ws, ticks):
    # currentLTP = ticks[-1]['last_price']
    print(ticks)
    # logging.debug("Ticks: {}".format(ticks))


def on_connect(ws, response):
    # Callback on successful connect.
    # Subscribe to a list of instrument_tokens (RELIANCE and ACC here).
    # Set RELIANCE to tick in `full` mode.
    ws.set_mode(ws.MODE_FULL, [738561])

def on_close(ws, code, reason):
    ws.stop()

kws.on_ticks = on_ticks
kws.on_connect = on_connect
kws.on_close = on_close

kws.connect()

"""
[
    {
    "tradable": true,
    "mode": "quote",
    "instrument_token": 5633,
    "last_price": 2637.65,
    "last_traded_quantity": 1,
    "average_traded_price": 2631.23,
    "volume_traded": 261121,
    "total_buy_quantity": 3,
    "total_sell_quantity": 0,
    "ohlc": {
        "open": 2635.05,
        "high": 2651.95,
        "low": 2608.75,
        "close": 2619.6
        },
    "change": 0.6890364941212469
    },
    {
    "tradable": true,
    "mode": "quote",
    "instrument_token": 738561,
    "last_price": 2941.2,
    "last_traded_quantity": 3,
    "average_traded_price": 2946.02,
    "volume_traded": 5003391,
    "total_buy_quantity": 1270,
    "total_sell_quantity": 0,
        "ohlc": {
        "open": 2966.7,
        "high": 2969.45,
        "low": 2933.05,
        "close": 2962.75
        },
    "change": -0.7273647793435215
    }
]
"""