from zNSE_fetch import nse_fetcher, prev_close_updaterNSE
from datetime import date
from pymongo import MongoClient
import mysql.connector as mc
import requests
import pandas as pd

url = "https://api.kite.trade/instruments"
client = MongoClient("mongodb://jenya:DJenya$Mongo%40St0ckDB@172.105.59.175:27017/")
db = client["trade_iq"]
enctoken_coll = db["zerodha_credentials"]
nseData_collection = db["nse_data1"]
bseData_collection = db["bse_data1"]
enctoken = enctoken_coll.find_one({ "date": f"{date.today()}" }, {"_id": 0, "date": 0, "websocket": 0})

payload = {}
headers = {
  'X-Kite-Version': '3',
  'authorization': f'enctoken {enctoken["enctoken"]}'
}

response = requests.request("GET", url, headers=headers, data=payload)

# Store response temporary
data = response.text
with open("instruments.csv", "wt", encoding="utf-8") as f:
    f.write(data)

# Read CSV File
df = pd.read_csv("instruments.csv")
eq_df = df[(df["instrument_type"] == "EQ") & (~pd.isna(df["name"]))]

def auto_nse():
    # Find symbols that are not found in NSE Collection
    nse_df = eq_df[eq_df["segment"] == "NSE"]
    nse_symbols = nse_df["tradingsymbol"].to_list()

    existing_symbols_cursor = nseData_collection.find({"symbol": {"$in": nse_symbols}}, {"symbol": 1})
    existing_symbols_list = list(existing_symbols_cursor)  # Convert cursor to list
    existing_symbols_set = set(symbol["symbol"] for symbol in existing_symbols_list)
    nse_not_in_mongo = nse_df[~nse_df["tradingsymbol"].isin(existing_symbols_set)]

    missing_nse_count = nse_not_in_mongo["tradingsymbol"].value_counts().shape[0]
    missing_symbols = nse_not_in_mongo.to_list()

def auto_bse():
    # Find symbols that are not found in BSE Collection
    bse_df = eq_df[eq_df["segment"] == "BSE"]
    bse_symbols = bse_df["tradingsymbol"].to_list()

    existing_symbols_cursor = bseData_collection.find({"symbol": {"$in": bse_symbols}}, {"symbol": 1})
    existing_symbols_list = list(existing_symbols_cursor)  # Convert cursor to list
    existing_symbols_set = set(symbol["symbol"] for symbol in existing_symbols_list)
    bse_not_in_mongo = bse_df[~bse_df["tradingsymbol"].isin(existing_symbols_set)]
    bse_not_in_mongo = bse_not_in_mongo[~bse_not_in_mongo["name"].str.contains("%", na=False)]

    missing_bse_count = bse_not_in_mongo["tradingsymbol"].value_counts().shape[0]
    missing_symbols = bse_not_in_mongo.to_list()

