from pymongo import MongoClient
import pandas as pd
import requests
import csv

import urllib.parse

indices = ['NIFTY 50', 'NIFTY NEXT 50', 'NIFTY 100', 'NIFTY 200', 'NIFTY 500', 'NIFTY MIDCAP 50', 'NIFTY MIDCAP 100', 'NIFTY SMALLCAP 100', 'INDIA VIX', 'NIFTY MIDCAP 150', 'NIFTY SMALLCAP 50', 'NIFTY SMALLCAP 250', 'NIFTY MIDSMALLCAP 400', 'NIFTY500 MULTICAP 50:25:25', 'NIFTY LARGEMIDCAP 250', 'NIFTY MIDCAP SELECT', 'NIFTY TOTAL MARKET', 'NIFTY MICROCAP 250', 'NIFTY500 LARGEMIDSMALL EQUAL-CAP WEIGHTED', 'NIFTY BANK', 'NIFTY AUTO', 'NIFTY FINANCIAL SERVICES', 'NIFTY FINANCIAL SERVICES 25/50', 'NIFTY FMCG', 'NIFTY IT', 'NIFTY MEDIA', 'NIFTY METAL', 'NIFTY PHARMA', 'NIFTY PSU BANK', 'NIFTY PRIVATE BANK', 'NIFTY REALTY', 'NIFTY HEALTHCARE INDEX', 'NIFTY CONSUMER DURABLES', 'NIFTY OIL & GAS', 'NIFTY MIDSMALL HEALTHCARE', 'NIFTY FINANCIAL SERVICES EX-BANK', 'NIFTY MIDSMALL FINANCIAL SERVICES', 'NIFTY MIDSMALL IT & TELECOM', 'NIFTY DIVIDEND OPPORTUNITIES 50', 'NIFTY GROWTH SECTORS 15', 'NIFTY100 QUALITY 30', 'NIFTY50 VALUE 20', 'NIFTY50 TR 2X LEVERAGE', 'NIFTY50 PR 2X LEVERAGE', 'NIFTY50 TR 1X INVERSE', 'NIFTY50 PR 1X INVERSE', 'NIFTY50 DIVIDEND POINTS', 'NIFTY ALPHA 50', 'NIFTY50 EQUAL WEIGHT', 'NIFTY100 EQUAL WEIGHT', 'NIFTY100 LOW VOLATILITY 30', 'NIFTY200 QUALITY 30', 'NIFTY ALPHA LOW-VOLATILITY 30', 'NIFTY200 MOMENTUM 30', 'NIFTY MIDCAP150 QUALITY 50', 'NIFTY200 ALPHA 30', 'NIFTY MIDCAP150 MOMENTUM 50', 'NIFTY500 MOMENTUM 50', 'NIFTY MIDSMALLCAP400 MOMENTUM QUALITY 100', 'NIFTY SMALLCAP250 MOMENTUM QUALITY 100', 'NIFTY TOP 10 EQUAL WEIGHT', 'NIFTY ALPHA QUALITY LOW-VOLATILITY 30', 'NIFTY ALPHA QUALITY VALUE LOW-VOLATILITY 30', 'NIFTY HIGH BETA 50', 'NIFTY LOW VOLATILITY 50', 'NIFTY QUALITY LOW-VOLATILITY 30', 'NIFTY SMALLCAP250 QUALITY 50', 'NIFTY TOP 15 EQUAL WEIGHT', 'NIFTY100 ALPHA 30', 'NIFTY200 VALUE 30', 'NIFTY500 EQUAL WEIGHT', 'NIFTY500 MULTICAP MOMENTUM QUALITY 50', 'NIFTY500 VALUE 50', 'NIFTY TOP 20 EQUAL WEIGHT', 'NIFTY COMMODITIES', 'NIFTY INDIA CONSUMPTION', 'NIFTY CPSE', 'NIFTY ENERGY', 'NIFTY INFRASTRUCTURE', 'NIFTY100 LIQUID 15', 'NIFTY MIDCAP LIQUID 15', 'NIFTY MNC', 'NIFTY PSE', 'NIFTY SERVICES SECTOR', 'NIFTY100 ESG SECTOR LEADERS', 'NIFTY INDIA DIGITAL', 'NIFTY100 ESG', 'NIFTY INDIA MANUFACTURING', 'NIFTY INDIA CORPORATE GROUP INDEX - TATA GROUP 25% CAP', 'NIFTY500 MULTICAP INDIA MANUFACTURING 50:30:20', 'NIFTY500 MULTICAP INFRASTRUCTURE 50:30:20', 'NIFTY INDIA DEFENCE', 'NIFTY INDIA TOURISM', 'NIFTY CAPITAL MARKETS', 'NIFTY EV & NEW AGE AUTOMOTIVE', 'NIFTY INDIA NEW AGE CONSUMPTION', 'NIFTY INDIA SELECT 5 CORPORATE GROUPS (MAATR)', 'NIFTY MOBILITY', 'NIFTY100 ENHANCED ESG', 'NIFTY CORE HOUSING', 'NIFTY HOUSING', 'NIFTY IPO', 'NIFTY MIDSMALL INDIA CONSUMPTION', 'NIFTY NON-CYCLICAL CONSUMER', 'NIFTY RURAL', 'NIFTY SHARIAH 25', 'NIFTY TRANSPORTATION & LOGISTICS', 'NIFTY50 SHARIAH', 'NIFTY500 SHARIAH']


for index_name in indices:
    def construct_nse_index_url(index_name):
        """
        Constructs the NSE India API URL for a given index name.

        Args:
            index_name (str): The name of the index (e.g., "NIFTY500 MULTICAP 50:25:25").

        Returns:
            str: The dynamically constructed URL.
        """
        # Base URL
        base_url = "https://www.nseindia.com/api/equity-stockIndices"

        # URL-encode the index name
        encoded_index_name = urllib.parse.quote(index_name)

        # Construct the full URL
        url = f"{base_url}?csv=true&index={encoded_index_name}&selectValFormat=crores"

        return url

    url = construct_nse_index_url(index_name=index_name)

    payload = {}
    headers = {
        'accept': '*/*',
        'accept-language': 'en-US,en;q=0.9',
        'cache-control': 'no-cache',
        'cookie': 'defaultLang=en; _ga=GA1.1.2045086731.1724406407; AKA_A2=A; _abck=A20DEE60683D2633C44E11729203793D~0~YAAQ9oosMWBbhYyUAQAAzFtgyg2BSLbOmHMEysnyzbub5DcUJfGO3foE4VS1c/8PtHCpmj1858yoLiXio/atQiVjWEEoxhS775tjibwL+Bp45PPER/iRAWfkuH2vZt2ZMbZzbnbVEikC4ZRSgUGrKn3xXsBHFqFEbCWqdoIuJDiGsnfVteKi6ljSawdkwIlVmgZAXz/AWUOlgH2waHpw7X7Z4ERIWVY8SoNu+805upU7XYTey9NJoIjqzQ4l2obpVp7xQ/9LmNfUe6TjhSETX9EZAdjaTXzUEsQuwl1iytMJJ0Zeg5MHpKsgijV5dbcAMZ1JgvtQIS72qCxAo5BdwLAZ7cqu9E2TxIIZyjh0lhN6CpENmOT8UiHf2feLcAUFx5xK5MWM/RNhVnxEiiU8ac3LRglCtDQ7Th/jMw9IJic8QbUYG4kHUaWycjEg699daqw0HpoJBGLFmRM5uHYEfHOPrC4eZtYhx3pS9GvWfGV3Gw==~-1~-1~-1; nsit=iZsnVjrhgECBZZFqeYHsKBLp; bm_mi=EA46E5C088B83C7F47A77743DC2D9CE5~YAAQ9oosMdbLh4yUAQAAtnFqyhrZrFslEHl0DEIDiQ8ip4qjMv4WLDcvxmwI9VfhRLg4HlA8jnHhjz6utDTRn0qxl2yInz8LwHat6BuZcvnwAkXZYOnU5yp9x0cdmbFb/u3BR/YWuMmRUfyh99LlzcfeTZT4wgq1zQ9oa3GVlV6oTp6PIWTWw0vKhfugBTburZgILtYzpG0WLtgXxiF8ykMfk8AZsdQxIAxsJNeM7t4nWvQGQZ8Wo5djYPqB55IHVoUSb1czuztoXtn3MJ322Si7OIWOXsbdF24yGyiQzG5tcFdgHkUMTCmolZFOItbhNw7hC/NuSc8RfVSzl1RvE6GywYrA86qtb9QP3x0=~1; ak_bmsc=FE6C6115F81B95161E807993A32D02F6~000000000000000000000000000000~YAAQ9oosMfTMh4yUAQAAhHZqyhoIpvO/cYWUjnFYZtPSxHXSBwgwLW20yCjqTZjCLoa3VA7P6kc0OYBvWWrhew9gO9mO049gm656Z2p45CBDB3BNZZwc5b/KHujoy4u0IExNTT33mFQoDFe/iGrhrmBG57fOG8bkwoZ4VVUg+euvvAcEUih5+Y/3PhRWxmI0Hv/iYpjpli5YMXKnYXILa5QBRfeAoLPxoP5uJPvNc5fZDK0LEWXz2OBoiGGivXF5ztVyWeDKzg5swNmQZ9mzc8ivYI8Mvp173ipaDGnaI3LgYO5kDNND4ZeFReazPlexxi8dwnhAz1ofcyhP5QGkagRXzd6ELOvtuJdolQcQsrjYTEmz5J163aBNwR+HPEPiqgiMhe6/reDJrWD2FY4zBB29J/8AJhRPTDGDH5Ro6NH9Hc1XodUW2B38K2uLzJEN6mjV8Gh58OQ7ApaHYvjQXDPz7EmpGgDrDOJ6LzzoskoClOvcbXCTdtc1b3/Gcja7jnvh1ha+9RHAl9K8TmA=; nseappid=eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJpc3MiOiJhcGkubnNlIiwiYXVkIjoiYXBpLm5zZSIsImlhdCI6MTczODU2MzMwNSwiZXhwIjoxNzM4NTcwNTA1fQ.wfgDXF4uVoYR9UR5cqg99t2q-rK0cG87dJi83KKuWDk; bm_sz=633FD7C9547C868896793C2E1F813AEC~YAAQ9oosMeraiYyUAQAArMNyyhoOSzIoyLk83cV+6xldC0AuiCS9M4mqDCBvKJdCMBYUdzJbsKVkGAjM0jH8S44ieJOT77rmKvjxiiog2TcjXiQ26tarBOOYMmH/RXz0tcfEa5qn+CKg/gYUljc7XJlOGRblmzt6Dzc7iOTPJKieoVJuQOa1WkY+YremFBhOO7tDSl8iS5B3OjMz/bTqdvvGTQ46f5d35E4TB6DNV84GpoEvOIgaHLGulm+iOJx3hJOqikzLdv70ai9PWY2HMTXqXg6xdbbT+YIZZ4ZNH1sGXVBhjgncrwgyhUxB1zewbCXfzt7UNgPXA/dSR234Z3Cdj14Xaf087/NU176tS0fLUO52sWdCKp5GfI1KKH8UHOh3p6VMJ6yZhCxgs7J3DiYuHtHC3ofPUynVE7iIxdCqlt2SvkKY/yWL6EdzGjsdAD+TTZyncbu4lzsQ2heipHih5EBqowaZbu62pYw=~3162435~3618869; _ga_87M7PJ3R97=GS1.1.1738561353.60.1.1738563307.59.0.0; _ga_WM2NSQKJEK=GS1.1.1738561353.20.1.1738563307.0.0.0; bm_sv=59C75A7CAFFF9D75FA83E70927F20A0C~YAAQ9oosMSHdiYyUAQAAn85yyhoWALitkFjAIYrSLmhXAICTIcff9O2I9LrDNN/X7SZgkgO2WIXGGYOgTMinKpDuBZSqn/xaS1A5oFALlAB2+Ji68pVklPPmFh/bUmBguq+GJ127XXlPyNhxCVfcpACYYefyX0WWZU+NhFynrVuB+E/2WZ3Pl4VAP4YALeNVWQlpdiz6u+HgDsoaM8ij7kqTiY6iXwmuMrbw8YIMflowYaXE0vrFsEOF3tueJ9O1pkxKRQ==~1; RT="z=1&dm=nseindia.com&si=59df17e1-a15d-4496-ae50-492fe1b7885f&ss=m6onpc9b&sl=0&se=8c&tt=0&bcn=%2F%2F684d0d42.akstat.io%2F&ld=bl91&nu=kpaxjfo&cl=368"; _abck=A20DEE60683D2633C44E11729203793D~-1~YAAQBopRaFORG7qUAQAAcAZzyg1oojakVpu91ydO0bIfRUeWTfQsIs7xs9wmCGFLfjUhNd5QYH2X7LMrxVVni9aJyc6uCeSiaY1c8NjeArYDY6M3R6agccxg5kut40En+vN6C01JBnHj9Xqt2gb6kYa7LSPZj/d9nw8/057e85fvpWMIGPqr50Ac+eO7kvdKHBmmEweh8pY84uW6K6ym5Q9SfyD7nfQk8BPaoVa+YeUj7wAyCtKnScb+YkPZRSKZbNB4ufzqgct2SIeVqWd02BNM+k2365Q9MpRYOG620GX+phx/E35ivHpOo0ckmjOvaKU+zky+kQIczVmFDxiJD3T1mW65iVbFHvl/mxUCsVImkEXnXOgboIgFx5P0349yxfnVVG+jSMvcpSDqfp8zZ6mtmVUrB4W4O45OrMzU+1Iqk00OX6BlrMvPHqMkrilZj6Z9I8ajjzfKy3r+1Pbqv7yjZOI+3v1h1TVLoxNwtcifbg==~0~-1~-1',
        'dnt': '1',
        'pragma': 'no-cache',
        'priority': 'u=1, i',
        'referer': 'https://www.nseindia.com/market-data/live-equity-market?symbol=NIFTY%20TRANSPORTATION%20%26%20LOGISTICS',
        'sec-ch-ua': '"Not A(Brand";v="8", "Chromium";v="132", "Google Chrome";v="132"',
        'sec-ch-ua-mobile': '?0',
        'sec-ch-ua-platform': '"Windows"',
        'sec-fetch-dest': 'empty',
        'sec-fetch-mode': 'cors',
        'sec-fetch-site': 'same-origin',
        'user-agent': 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/132.0.0.0 Safari/537.36',
        'x-requested-with': 'XMLHttpRequest'
    }

    client = MongoClient("mongodb://jenya:DJenya$Mongo%40St0ckDB@172.105.59.175:27017/")
    db = client["trade_iq"]
    collection = db["indices_nse"]

    response = requests.request("GET", url, headers=headers, data=payload).text

    # Open a CSV file in write mode
    with open('output.csv', mode='w', encoding="utf-8", newline='') as file:
        file.write(response)

    try:
        symbols = []
        with open('output.csv', mode='r', encoding="utf-8", newline='') as file:
            a = file.readlines()
            for i in a[16:]:
                symbol = i.split(',')[0].strip('"')
                symbols.append(symbol)

        structure = {
            "Index": symbols[0],
            "symbols": symbols[1:]
        }
    except IndexError:
        continue

    collection.insert_one(structure)
    client.close()
