import csv

def csv_to_sql(csv_file, table_name, sql_file):
    # Open CSV file
    with open(csv_file, mode='r', newline='', encoding='utf-8') as f:
        reader = csv.reader(f)
        # Get the headers (columns)
        headers = next(reader)

        # Prepare the SQL insert template
        insert_statement = f"INSERT INTO {table_name} ({', '.join(headers)}) VALUES "

        # Open the SQL file to write
        with open(sql_file, mode='w', encoding='utf-8') as sql_f:
            for row in reader:
                # Create a SQL values string
                values = ', '.join([f"'{value}'" if value != '' else 'NULL' for value in row])
                # Write the insert statement for each row
                sql_f.write(f"{insert_statement}({values});\n")

# Example usage
csv_to_sql('mytable.csv', 'mytable', 'insert_statements.sql')
