from kivy.app import App
from kivy.uix.boxlayout import BoxLayout
from kivy.uix.button import Button
import webview  # pip install pywebview

class WebViewApp(App):
    def build(self):
        layout = BoxLayout(orientation='vertical')
        
        # Create a back button
        back_button = Button(text='Back', size_hint=(1, 0.1))
        back_button.bind(on_press=self.go_back)
        
        # Add widgets to the layout
        layout.add_widget(back_button)
        
        # Start the webview window
        self.webview = webview.create_window('WebView', 'https://www.tixbag.com')
        webview.start()
        
        return layout

    def go_back(self, instance):
        if self.webview.can_go_back():
            self.webview.go_back()
        else:
            print("Cannot go back further")  # Provide feedback to the user

if __name__ == '__main__':
    WebViewApp().run()